#!/bin/bash

#default values
cppcompiler=g++
debug=n
ph_debug=n
lib_debug=n
strip_prog=strip
target=i386
prefix=
cxxflags="-Wall"
builddir="../build/"
installer="install -D"
installdir="/usr"
depend="makedepend"

echo "--- PeerHood Configuration Script ---"
echo ""

#build target
echo -e "Build target (i386/ipaq) [i386]: \c"
read tmp
while [ "$tmp" != "" -a "$tmp" != "ipaq" ] ; do
	read tmp
done
if [ "$tmp" != "" ] ; then target=ipaq ; fi

#compiler etc prefix for a cross-compiler
if [ "$target" == "ipaq" ] ; then 
	prefix="arm-linux-"
	tmp=""
	echo -e "Prefix [$prefix]: \c"
	read tmp
	if [ "$tmp" != "" ] ; then prefix=tmp; fi
fi

#figure out the right compiler
echo -e "C++ compiler [g++]: \c"
tmp=""
read tmp
if [ -n "$tmp" ] ; then cppcompiler=$tmp ; fi

#file for install
echo -e "Executable for installing files [$installer]: \c"
tmp=""
read tmp
if [ -n "$tmp" ] ; then installer=$tmp; fi

#executable for dependencies
echo -e "Executable for creating dependencies files [$depend]: \c"
tmp=""
read tmp
if [ -n "$tmp" ] ; then depend=$tmp; fi

#installation directory
echo -e "Select installation directory [$installdir]: \c"
tmp=""
read tmp
if [ -n "$tmp" ] ; then installdir=$tmp;fi

#build for debug / release
echo -e "Build debug information (y/n): \c"
while [ "$tmp" != "y" -a "$tmp" != "n" ] ; do
	read tmp
done
if [ "$tmp" == "y" ] ; then debug=y ; cxxflags=$cxxflags" -g" ; fi

#enable daemon debug messages
echo -e "Enable daemon debug messages (y/n): \c"
tmp=""
while [ "$tmp" != "y" -a "$tmp" != "n" ] ; do
	read tmp
done
if [ "$tmp" == "y" ] ; then ph_debug=y ; fi

#enable library debug messages
echo -e "Enable library debug messages (y/n): \c"
tmp=""
while [ "$tmp" != "y" -a "$tmp" != "n" ] ; do
	read tmp
done
if [ "$tmp" == "y" ] ; then lib_debug=y ; fi

#ok, write new MakeVars
echo "TARGET=$target" > MakeVars
echo "CXX=$prefix$cppcompiler" >> MakeVars
echo "CXXFLAGS=$cxxflags -I../include" >> MakeVars
echo "INSTALL=$installer" >>MakeVars
echo "DEPEND=$depend" >>MakeVars
echo "INSTALLDIR=$installdir" >>MakeVars
echo "DEBUG=$debug" >> MakeVars
echo "PH_DEBUG=$ph_debug" >> MakeVars
echo "LIB_DEBUG=$lib_debug" >> MakeVars
echo "STRIP=$prefix$strip_prog" >> MakeVars
echo "BUILDDIR=$builddir" >> MakeVars
echo "BT_PLUGIN_LDFLAGS=-lbluetooth -lpthread" >> MakeVars

#echo "TARGET=$target" > test/MakeVars
#echo "CXX=$prefix$cppcompiler" >> test/MakeVars
#echo "CXXFLAGS=$cxxflags -I../../include" >> test/MakeVars
#echo "LDFLAGS=-L../../lib -lpeerhood -lbluetooth -lpthread -ldl" >> test/MakeVars
#echo "DEBUG=$debug" >> test/MakeVars
#echo "LIB_DEBUG=$lib_debug" >> test/MakeVars
#echo "STRIP=$prefix$strip_prog" >> test/MakeVars

