/** This file is part of PeerHood.
*
*   PeerHood is free software: you can redistribute it and/or modify
*   it under the terms of the GNU Lesser General Public License 
*   version 2 as published by the Free Software Foundation.
*
*   PeerHood is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU Lesser General Public License for more details.
*
*   You should have received a copy of the GNU Lesser General Public
*   License along with PeerHood. If not, see <http://www.gnu.org/licenses/>.
*/

// Emacs, hail the mighty -*-C++-*-

/**
 * Copyright 2003 LUT. .
 *
 * @name VirtualConnection.h
 * @memo virtual implementation of the MAbstractConnection
 * interface.
 *
 * @version 0.2
 * date     07.01.2004
 * change   28.04.2010
 */

#ifndef __VIRTUALCONNECTION_H__
#define __VIRTUALCONNECTION_H__

#include <string>
//#include <AbstractConnection.h>
#include "PeerHoodImpl.h"

class CThreadInfo;
/**
 * @memo virtual-specific implementation of the MAbstractConnection
 * interface.
 * @doc virtual-specific implementation of the MAbstractConnection interface.
 *
 * @see MAbstractConnection
 */
class CVirtualConnection : public MAbstractConnection
{
 public:
  CVirtualConnection(const std::string& aPrototype);
  CVirtualConnection(const std::string& aPrototype, CThreadInfo* aThreadInfo);
  ~CVirtualConnection();
  MAbstractConnection* AcceptL();
  void Close();
  bool Connect(const std::string& aAddress, int aPort);
  bool Disconnect();
  bool Listen();
  bool Listen(int aPort);
  bool IsConnected();
  bool IsListening();
  bool HasData();
  int Write(const void* aOutBuf, int aLength);
  int Read(void* aInBuf, int aLength);
  const std::string& GetRemoteAddress();
  unsigned int GetDeviceChecksum();
  void SetDeviceChecksum(unsigned int aChecksum);
  int GetFd();
  
  void SetConnectionType(MAbstractConnection* aConnection);
  void SetConnectionType(MAbstractConnection* aConnection, std::string& aPrototype, std::string& aAddress, int aPort);

 private:
  int iSocket;
  bool iConnected;
  bool iIsListening;
  MAbstractConnection* iVirtualConnection;
  std::string iRemoteAddress;
  CThreadInfo *iThreadInfo;
  
};

#endif //__VIRTUALCONNECTION_H__
