/** This file is part of PeerHood.
*
*   PeerHood is free software: you can redistribute it and/or modify
*   it under the terms of the GNU Lesser General Public License 
*   version 2 as published by the Free Software Foundation.
*
*   PeerHood is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU Lesser General Public License for more details.
*
*   You should have received a copy of the GNU Lesser General Public
*   License along with PeerHood. If not, see <http://www.gnu.org/licenses/>.
*/

// Emacs, hail the mighty -*-C++-*-

/**
 * Copyright 2003 LUT. .
 *
 * @name Service.h
 * @memo Defines PeerHood's service class.
 *
 * @version 0.2
 * date     22.04.2003
 * change   18.02.2010
 */

#ifndef __SERVICE_H__
#define __SERVICE_H__

#ifdef __cplusplus

#include <string>

/**
 * @memo Defines PeerHood's service class.
 * @doc Defines PeerHood's service class. In the PeerHood system, each service
 * is presented as an instance of this class. 
 */
class CService
{
 public:
  CService(const CService& aOriginal);
  CService(const char* aData);
  CService(const char* aData, int aPid);
  CService(const char* aData, const std::string& aKey);
  //  CService(const std::string& aName, const std::string& aAttributes, int aPid);
  CService(const std::string& aName, const std::string& aAttributes, int aPid, unsigned short aPort);

  char* MarshallL(int* aLength);
  int MarshalledLength();

  int GetPid();
  unsigned short GetPort();
  const std::string& GetAttributeString();
  bool GetAttribute(std::string& aKey);
  const std::string& GetName();
   
 private:
  int iPid;
  unsigned short iPort;
  std::string iAttributes;
  std::string iName;
};

#else
	typedef
		struct CService
			CService;
#endif

#ifdef __cplusplus
extern "C" {
#endif

int ph_c_service_get_pid(CService* _aService);
unsigned short ph_c_service_get_port(CService* _aService);
const char* ph_c_service_get_attributes(CService* _aService);
const char* ph_c_service_get_attribute(CService* _aService, char* _aKey);
const char* ph_c_service_get_name(CService* _aService);

#ifdef __cplusplus
}
#endif
#endif // __SERVICE_H__
