/** This file is part of PeerHood.
*
*   PeerHood is free software: you can redistribute it and/or modify
*   it under the terms of the GNU Lesser General Public License 
*   version 2 as published by the Free Software Foundation.
*
*   PeerHood is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU Lesser General Public License for more details.
*
*   You should have received a copy of the GNU Lesser General Public
*   License along with PeerHood. If not, see <http://www.gnu.org/licenses/>.
*/

/**
 * Copyright 2009,2010 LUT.
 *
 * @name IteratorWrapper.cc
 * @memo Implementations of IteratorWrapper.h class functions for C-API.
 *
 * @version 0.2
 * date     20.11.2009
 * change   26.01.2010
 */

#include "IteratorWrapper.h"

/********* DEVICEITERATOR **********/

/**
 * @memo Constructor for DeviceIterator (PRIVATE)
 * @doc Private Constructor for DeviceIterator - cannot be used!.
 */
DeviceIterator::DeviceIterator()
{
}

/**
 * @memo Constructor for DeviceIterator
 * @doc Create new DeviceIterator and initialize the actual iterator.
 */
DeviceIterator::DeviceIterator(TDeviceIterator aDeviceIterator)
{
	iIterator = aDeviceIterator;
}

/**
 * @memo Destructor for DeviceIterator
 * @doc Delete the DeviceIterator
 */
DeviceIterator::~DeviceIterator()
{
}

/**
 * @memo Get the iterator.
 * @doc Returns the content of this wrapper.
 *
 * @return The content of the wrapper
 */
TDeviceIterator DeviceIterator::GetIterator()
{
	return iIterator;
}

/**
 * @memo Set a specific iterator as content.
 * @doc Assign the given iterator object to be as the content of this
 * iterator.
 */
void DeviceIterator::SetIterator(TDeviceIterator aIterator)
{
	iIterator = aIterator;
}

/**
 * @memo Increase the iterator,
 * @doc Move on to the next actual iterator.
 */
void DeviceIterator::NextIterator()
{
	SetIterator(++iIterator);
}


/************ SERVICEITERATOR *************/

/**
 * @memo Constructor for ServiceIterator (PRIVATE)
 * @doc Private Constructor for ServiceIterator - cannot be used!.
 */
ServiceIterator::ServiceIterator()
{
}

/**
 * @memo Constructor for ServiceIterator
 * @doc Create new ServiceIterator and initialize the actual iterator.
 */
ServiceIterator::ServiceIterator(TServiceIterator aServiceIterator)
{
	iIterator = aServiceIterator;
}

/**
 * @memo Destructor for ServiceIterator
 * @doc Delete the ServiceIterator
 */
ServiceIterator::~ServiceIterator()
{
}

/**
 * @memo Get the iterator.
 * @doc Returns the content of this wrapper.
 *
 * @return The content of the wrapper
 */
TServiceIterator ServiceIterator::GetIterator()
{
	return iIterator;
}

/**
 * @memo Set a specific iterator as content.
 * @doc Assign the given iterator object to be as the content of this
 * iterator.
 */
void ServiceIterator::SetIterator(TServiceIterator aIterator)
{
	iIterator = aIterator;
}

/**
 * @memo Increase the iterator,
 * @doc Move on to the next actual iterator.
 */
void ServiceIterator::NextIterator()
{
	SetIterator(++iIterator);
}


