/* $Id: autosave.cc,v 1.4 2005/08/23 15:43:32 murrayc Exp $ */
/* 
 *
 * Copyright 2007 The maemomm development team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <libossomm/autosave.h>
#include <libosso.h>

namespace Osso
{

static void
on_autosave(gpointer data)
{
  SlotAutoSave* slot = static_cast<SlotAutoSave*>(data);
  if(slot)
  {
    (*slot)();
  }	
}

osso_return_t application_set_autosave_cb(osso_context_t* osso, const SlotAutoSave& slot)
{
  SlotAutoSave* slot_copy = new SlotAutoSave(slot);
  return osso_application_set_autosave_cb(osso, &on_autosave, slot_copy);
  //TODO: osso_application_set_autosave_cb() should take a destroy func.
}

} //namespace Osso
