/* $Id: hw.cc,v 1.4 2005/08/23 15:43:32 murrayc Exp $ */
/* 
 *
 * Copyright 2007 The maemomm development team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <libossomm/hw.h>
#include <libosso.h>

namespace Osso
{

static void
on_hw(osso_hw_state_t* state, gpointer data)
{
  SlotHW* slot = static_cast<SlotHW*>(data);
  if(slot)
  {
    (*slot)(state);
  }	
}

osso_return_t hw_set_event_cb(osso_context_t* osso, const SlotHW& slot)
{
  SlotHW* slot_copy = new SlotHW(slot);
  return osso_hw_set_event_cb(osso, NULL /* state. Means all states */, &on_hw, slot_copy);
  //TODO: osso_hw_set_event_cb() should take a destroy func.
}

osso_return_t hw_set_event_cb(osso_context_t* osso, osso_hw_state_t* state, const SlotHW& slot)
{
  SlotHW* slot_copy = new SlotHW(slot);
  return osso_hw_set_event_cb(osso, state, &on_hw, slot_copy);
  //TODO: osso_hw_set_event_cb() should take a destroy func.
}

} //namespace Osso
