/* $Id: autosave.h,v 1.4 2005/08/23 15:43:32 murrayc Exp $ */
/* 
 *
 * Copyright 2007 The maemomm development team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef LIBOSSOMM_INIT_H
#define LIBOSSOMM_INIT_H

#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>
#include <libosso.h> //TODO: Hide this?

namespace Osso
{

/** For instance, 
 * @code
 * void on_hw(osso_hw_state_t *state);
 * @endcode
 *
 * @param state The current state of the device.
 */
typedef sigc::slot<void, osso_hw_state_t*> SlotHW;

/**
 * This function registers a callback function that is called whenever
 * the state of the device changes. To specify that you are interested only 
 * in specific states, use the method overload that takes a state parameter.
 *
 * The first call to this function will
 * also check the current state of the device, and if the state is available,
 * the corresponding callback function will be called immediately.
 * 
 * @param osso The library context as returned by #osso_initialize.
 * @param slot The callback function.
 * @return #OSSO_OK if all goes well, #OSSO_ERROR if an error occurred, or
 * #OSSO_INVALID if some parameter is invalid.
 */
osso_return_t hw_set_event_cb(osso_context_t* osso, const SlotHW& slot);


/**
 * This function registers a callback function that is called whenever
 * the state of the device changes.
 *
 * The first call to this function will
 * also check the current state of the device, and if the state is available,
 * the corresponding callback function will be called immediately.
 * 
 * @param osso The library context as returned by #osso_initialize.
 * @param state The states the application is interested in. NULL can be
 * passed here to indicate that all signals are of interest.
 * @param slot The callback function.
 * @return #OSSO_OK if all goes well, #OSSO_ERROR if an error occurred, or
 * #OSSO_INVALID if some parameter is invalid.
 */
osso_return_t hw_set_event_cb(osso_context_t* osso, osso_hw_state_t* state, const SlotHW& slot);

} //namespace Osso

#endif /* #ifndef LIBOSSOMM_INIT_H */
