<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="text"/>
<xsl:param name="UID"/>  
<xsl:param name="TOKEN"/>  
<xsl:param name="PRIVATE"/>

<xsl:variable name="RESPONSE" select="'Response'"/>
<xsl:variable name="PARAMS" select="'Params'"/>
<xsl:variable name="STRING" select="'string'"/>
<xsl:variable name="NUMBER" select="'number'"/>
<xsl:variable name="STRUCT" select="'struct'"/>
<xsl:variable name="ARRAY" select="'array'"/>

<xsl:include href="errors.xsl"/>

<xsl:template match="/">
 <xsl:apply-templates select="/data/response_messages_getThread"/>
 <xsl:apply-templates select="/data/error"/>
 <xsl:apply-templates select="/data/info"/>
</xsl:template>

<xsl:template match="response_messages_getThread">

    <xsl:element name="{$RESPONSE}">
        <xsl:attribute name="class">messages</xsl:attribute>
        <xsl:attribute name="function">getListThreadMessages</xsl:attribute>
        <xsl:element name="{$PARAMS}">

            <xsl:element name="{$ARRAY}">
                <xsl:variable name="quantity" select="count(anon)"/>

                <xsl:attribute name="name">messageList</xsl:attribute>
                <xsl:attribute name="page">
                        <xsl:value-of select="/data/Request/Params/number[@name='page']"/> 
                </xsl:attribute>

                <xsl:attribute name="pageSize">
                        <xsl:value-of select="/data/Request/Params/number[@name='pageSize']"/> 
                </xsl:attribute>

                <xsl:attribute name="threadId">
                        <xsl:value-of select="/data/Request/Params/string[@name='threadId']"/> 
                </xsl:attribute>

                <xsl:attribute name="quantity">
                        <xsl:value-of select="number($quantity)"/>
                </xsl:attribute>

                <xsl:for-each select="anon">
                        <xsl:element name="{$STRUCT}">
                            <xsl:attribute name="name">message</xsl:attribute>
             
                            <xsl:attribute name="id">
                            <xsl:value-of select="/data/Request/Params/string[@name='threadId']"/>
                            <xsl:text>_</xsl:text> 
                            <xsl:value-of select="time"/>
                            </xsl:attribute>

                            <xsl:if test="type = '1'">
                                <xsl:element name="{$STRING}">
                                   <xsl:attribute name="name">SenderId</xsl:attribute>
                                    <xsl:value-of select="/data/Request/Params/string[@name='threadId']"/> 
                                </xsl:element>
                                <xsl:element name="{$STRING}">
                                   <xsl:attribute name="name">SenderName</xsl:attribute>
                                        <xsl:value-of select="/data/Request/Params/string[@name='FirstName']"/>
                                        <xsl:text> </xsl:text>
                                        <xsl:value-of select="/data/Request/Params/string[@name='LastName']"/>
                                </xsl:element>

                            </xsl:if>
                            <xsl:if test="type = '0'">
                                <xsl:element name="{$ARRAY}">
                                    <xsl:attribute name="name">recipientList</xsl:attribute>
                                    <xsl:attribute name="quantity">1</xsl:attribute>
                                    <xsl:element name="{$STRUCT}">
                                    <xsl:attribute name="name">recipient</xsl:attribute>
                                    <xsl:element name="{$STRING}">
                                       <xsl:attribute name="name">RecipientId</xsl:attribute>
                                        <xsl:value-of select="/data/Request/Params/string[@name='threadId']"/> 
                                    </xsl:element>
                                <xsl:element name="{$STRING}">
                                   <xsl:attribute name="name">RecipientName</xsl:attribute>
                                        <xsl:value-of select="/data/Request/Params/string[@name='FirstName']"/>
                                        <xsl:text> </xsl:text>
                                        <xsl:value-of select="/data/Request/Params/string[@name='LastName']"/>
                                </xsl:element>

                                </xsl:element>
                                </xsl:element>

                            </xsl:if>

                            <xsl:element name="{$STRING}">
                                <xsl:attribute name="name">Time</xsl:attribute>
                                <xsl:value-of select="time"/>
                            </xsl:element>

                            <xsl:element name="{$STRING}">
                                <xsl:attribute name="name">Text</xsl:attribute>
                                <xsl:value-of select="filtered_message"/>
                            </xsl:element>

                        </xsl:element>
                </xsl:for-each>
            </xsl:element> 

        </xsl:element> 
    </xsl:element> 
</xsl:template>

</xsl:stylesheet>
