/*
 * pb_parser.c -  parser for MySocials driver
 * This file is part of MSA program
 *
 * Copyright (C) 2009, 2010, 2011 - MySocials team
 *
 * MSA program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * MSA program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with MSA program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA  02110-1301  USA
 */
#include "parser.h"

/*
 * Parse back url
 *
 * @param inner_req - inner request
 * @param cp - profile
 * @param data - redirect url from server
 * @param data_size - size of url
 * @param response - response in xml
 * @return 0 if login success, 1 if login failure
 */
#ifdef NOT_USE_DEFAULT_WEBAUTH_PARSER
int webauth_parser(xmlDocPtr inner_req, const struct ProfileData *cp, gchar* data, int data_size, gchar **response)
{
    if(data != NULL){
        if(g_strcmp0(data,"http://photobucket.com/apilogin/done") == 0)
            *response = g_strdup(MSG_AUTH_SUCCESS);
            return 0;
    } 
    *response = g_strdup(MSG_AUTH_ERROR);
    return 1;
}
#endif

#ifdef NOT_USE_DEFAULT_TEXT_PARSER
int text_parser(xmlDocPtr inner_req, const struct ProfileData *cp, gchar* data, int data_size, gchar **response)
{
    MSA_UNUSED(inner_req);
    MSA_UNUSED(cp);
    MSA_UNUSED(data_size);

    gchar **params = NULL;
    int i = 0;
    gchar *tmp = NULL, *param = NULL;

    if(data != NULL){
                params = g_strsplit_set(data, "&=", 20);
                if (params[0] != NULL){
                    tmp = g_strdup("<response>");
                    for(i = 0; i < g_strv_length(params); i+=2){
                        param = g_strconcat(tmp, "<",params[i],">", params[i+1], "</",params[i],">", NULL);
                        g_free(tmp);
                        tmp = g_strdup(param); 
                        g_free(param);
/*
                        msa_debug("params[%d]=%s", i, params[i]);
                        if(g_strcmp0(params[i], "oauth_token") == 0){
                            token = g_strdup(params[i+1]);
                        }
                        if(g_strcmp0(params[i], "oauth_token_secret") == 0){
                            token_secret = g_strdup(params[i+1]);
                        }
*/
                    }

                    *response = g_strconcat(tmp, "</response>", NULL );
                    g_free(tmp); 
/*
                    msa_debug("token = %s, token_secret = %s",token , token_secret);
                    *response = g_strconcat("<response>", 
                                            "<token>", token, "</token>", 
                                            "<token_secret>", token_secret, "</token_secret>", 
                                            "</response>", NULL);
*/
                    msa_debug("response = %s", *response);
                    g_strfreev(params);
/*
                    g_free(token);
                    g_free(token_secret);
*/
                    return 0;
                }
    } 
    *response = g_strdup(MSG_AUTH_ERROR);
    return 1;
}
#endif

#ifdef NOT_USE_DEFAULT_PROCESS_URL
void process_url(xmlDocPtr inner_req, const struct ProfileData *cp, gchar* data, int data_size, gchar **response)
{
    HMAC_CTX hmac;
    unsigned char hmac_value[2048];
    int len;
    unsigned char *key = NULL;
    unsigned char *token_secret = NULL;
    xmlNodePtr type_node = NULL, url_node = NULL, param_node = NULL, token_node = NULL;
    gchar *sig = NULL, *sha1_sig = NULL;
    gchar *type = NULL, *url = NULL, *param = NULL;
    gchar *type_enc = NULL, *url_enc = NULL, *param_enc = NULL;

    token_node = xpath_get_node("//InnerRequest/token_secret", inner_req);
    if (token_node != NULL)
        token_secret = (gchar*)xmlNodeGetContent(token_node);
    token_node = NULL;

    key = g_strconcat(CONSUMER_SECRET, "&", token_secret, NULL);
    msa_debug("key for sha1 = %s", key);

    type_node = xpath_get_node("//InnerRequest/sig/type", inner_req);
    url_node = xpath_get_node("//InnerRequest/sig/url", inner_req);
    param_node = xpath_get_node("//InnerRequest/sig/params", inner_req);

    if (type_node != NULL && url_node != NULL && param_node != NULL){

        type = (gchar*)xmlNodeGetContent(type_node);
        type_enc = g_uri_escape_string(type, NULL, 0);
        url = (gchar*)xmlNodeGetContent(url_node);
        url_enc = g_uri_escape_string(url, NULL, 0);
        param = (gchar*)xmlNodeGetContent(param_node);
        param_enc = g_uri_escape_string(param, NULL, 0);

        sig = g_strconcat(type_enc, "&", url_enc, "&", param_enc, NULL);
        g_free(type);
        g_free(type_enc);
        g_free(url);
        g_free(url_enc);
        g_free(param);
        g_free(param_enc);
 
        msa_debug("compute sha1 for %s\n", sig);
        HMAC_CTX_init(&hmac);
        HMAC(EVP_sha1(), key, strlen(key), sig, strlen(sig), hmac_value,&len);
        HMAC_CTX_cleanup(&hmac);
        sha1_sig=g_base64_encode(hmac_value, len);
        sha1_sig = g_uri_escape_string(sha1_sig, NOT_ESCAPE2, 0);
        msa_debug("sha1=%s", sha1_sig);
        g_free(sig);
        *response = g_strconcat(data, "oauth_signature=", sha1_sig, NULL);
        g_free(sha1_sig);
    } else                 
        *response = g_strdup(data);
}
#endif
