<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="text"/>
<xsl:param name="USERNAME"/>  
<xsl:param name="TOKEN"/>  
<xsl:param name="SECRET"/>  
<xsl:param name="TIME"/>  
<xsl:param name="NONCE"/>

<xsl:variable name="REQUEST" select="'Request'"/>
<xsl:variable name="RESPONSE" select="'Response'"/>
<xsl:variable name="PARAMS" select="'Params'"/>
<xsl:variable name="STRING" select="'string'"/>
<xsl:variable name="IMG" select="'img'"/>

<xsl:include href="errors.xsl"/>

<xsl:template match="/">
 <xsl:apply-templates select="/data/response"/>
 <xsl:apply-templates select="/data/error"/>
 <xsl:apply-templates select="/data/info"/>
</xsl:template>

<xsl:template match="response">
    <xsl:element name="{$RESPONSE}">
        <xsl:attribute name="class">profile</xsl:attribute>
        <xsl:attribute name="function">getBaseProfile</xsl:attribute>
        <xsl:element name="{$PARAMS}">

            <xsl:attribute name="id">
                <xsl:choose>
                <xsl:when test="/data/Request/Params/@id">
                    <xsl:value-of select="/data/Request/Params/@id"/> 
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="$USERNAME"/>     
                </xsl:otherwise>
                </xsl:choose>
            </xsl:attribute>

            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">NickName</xsl:attribute>
                <xsl:choose>
                <xsl:when test="/data/Request/Params/@id">
                    <xsl:value-of select="/data/Request/Params/@id"/> 
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="$USERNAME"/>     
                </xsl:otherwise>
                </xsl:choose>
            </xsl:element> 
        </xsl:element> 

    </xsl:element> 
</xsl:template>
</xsl:stylesheet>
