#include <microfeed/microfeedjson.h>
#include <string.h>
#include <stdio.h>

char* data = "\
         {\
	        \"testi\"        :          \"jee\",\"a\":\"c\"\
      , \"juttu\" : { \"object\" : -123.2 }}\
";
int main(void) {
	MicrofeedJson* json;
	int i;
	char* s;
	
	if ((json = microfeed_json_new_from_data(data, strlen(data)))) {
		for (i = 0; i < microfeed_json_get_size(json); i++) {
			printf("%s: %s\n", microfeed_json_get_name_by_index(json, i), microfeed_json_get_string_by_index(json, i));
		}
		printf("# %s\n", microfeed_json_get_as_string_by_path(json, "juttu", "object", NULL));
		s = microfeed_json_to_string(json, NULL);
		printf(": %s :\n", s);
		free(s);

	}
	microfeed_json_free(json);
	
	return 0;
}
