#include <string.h>
#include <gtk/gtk.h>
#ifndef NO_HILDON
#include <hildon/hildon.h>
#include <hildon-extras/he-menu-view.h>
#endif /* NO_HILDON */

static void
get_first_label_found(GtkWidget *widget, GtkWidget **p_label)
{
	if (GTK_IS_LABEL(widget))
		(*p_label) = widget;
	else
	if (GTK_IS_CONTAINER(widget))
		gtk_container_forall(GTK_CONTAINER(widget), (GtkCallback)get_first_label_found, p_label);
}

static const char *
_hmv_private_menu_item_get_label(GtkWidget *menu_item)
{
	GtkWidget *label = NULL;

	g_return_val_if_fail(GTK_IS_MENU_ITEM(menu_item), NULL);

	get_first_label_found(menu_item, &label);

	return label ? gtk_label_get_text(GTK_LABEL(label)) : NULL;
}

static void
add_items(GtkWidget *widget, GArray *array)
{
	if (GTK_IS_MENU_ITEM(widget)) {
		GtkWidget *submenu = gtk_menu_item_get_submenu(GTK_MENU_ITEM(widget));

		g_array_append_val(array, widget);
		if (submenu)
			gtk_container_foreach(GTK_CONTAINER(submenu), (GtkCallback)add_items, array);
	}
	else
	if (GTK_IS_CONTAINER(widget))
		gtk_container_foreach(GTK_CONTAINER(widget), (GtkCallback)add_items, array);
}

typedef struct {
	guint gio_stdin_read_id;
	GtkWidget *toplevel_menu;
	GArray *array;
	GIOChannel *gio_stdin;
} MenuDestroyedParams;

static gboolean
stuff_on_stdin(GIOChannel *gio_stdin, GIOCondition *cond, MenuDestroyedParams *params)
{
	char *str = NULL;

	if (G_IO_STATUS_NORMAL == g_io_channel_read_line(gio_stdin, &str, NULL, NULL, NULL))
		if (str) {
			if (!g_strcmp0("ls\n", str)) {
				int Nix;
				for (Nix = 0 ; Nix < params->array->len ; Nix++)
					g_print("\"%s\"\n", _hmv_private_menu_item_get_label(g_array_index(params->array, GtkWidget *, Nix)));
			}
			else
			if (!strncmp("set-label", str, 9)) {
				GRegex *regex = g_regex_new("^set-label \"([^\"]*)\" \"([^\"]*)\"$", 0, 0, NULL);

				g_print("Setting label ...\n");

				if (regex) {
					GMatchInfo *match_info = NULL;

					g_regex_match(regex, str, 0, &match_info);

					if (match_info) {
						char *item_name = g_match_info_fetch(match_info, 1);
						char *new_name  = g_match_info_fetch(match_info, 2);

						if (item_name && new_name) {
							int Nix;

							for (Nix = 0 ; Nix < params->array->len ; Nix++)
								if (!g_strcmp0(item_name, _hmv_private_menu_item_get_label(g_array_index(params->array, GtkWidget *, Nix))))
									break;

							if (Nix < params->array->len) {
								GtkWidget *label = NULL;
								get_first_label_found(g_array_index(params->array, GtkWidget *, Nix), &label);
								if (label)
									g_object_set(G_OBJECT(label), "label", new_name, NULL);
							}
						}
						g_free(item_name);
						g_free(new_name);

						g_match_info_free(match_info);
					}
				}
			}
			else
			if (!strncmp("set", str, 3)) {
				GRegex *regex = g_regex_new("^set \"([^\"]*)\" \"([^\"]*)\" (.*)$", 0, 0, NULL);

				if (regex) {
					GMatchInfo *match_info = NULL;

					g_regex_match(regex, str, 0, &match_info);

					if (match_info) {
						char *item_name = g_match_info_fetch(match_info, 1);
						char *prop_name = g_match_info_fetch(match_info, 2);
						char *value     = g_match_info_fetch(match_info, 3);

						if (item_name && prop_name && value) {
							int Nix;
							gboolean b_val = (g_strcmp0(value, "FALSE") ? TRUE : FALSE);

							for (Nix = 0 ; Nix < params->array->len ; Nix++)
								if (!g_strcmp0(item_name, _hmv_private_menu_item_get_label(g_array_index(params->array, GtkWidget *, Nix))))
									break;

							if (Nix < params->array->len) {
								g_object_set(G_OBJECT(g_array_index(params->array, GObject *, Nix)), prop_name, b_val, NULL);
								g_print("g_object_set(G_OBJECT(%s), %s, %s, NULL)\n",
									_hmv_private_menu_item_get_label(g_array_index(params->array, GtkWidget *, Nix)),
									prop_name, b_val ? "TRUE" : "FALSE");
							}
						}

						g_free(item_name);
						g_free(prop_name);
						g_free(value);

						g_match_info_free(match_info);
					}
				}
			}
			else
			if (!strncmp("kill", str, 4)) {
				GRegex *regex = g_regex_new("^kill \"([^\"]*)\"$", 0, 0, NULL);

				if (regex) {
					GMatchInfo *match_info = NULL;

					g_regex_match(regex, str, 0, &match_info);

					if (match_info) {
						char *item_name = g_match_info_fetch(match_info, 1);

						if (item_name) {
							int Nix;

							for (Nix = 0 ; Nix < params->array->len ; Nix++)
								if (!g_strcmp0(item_name, _hmv_private_menu_item_get_label(g_array_index(params->array, GtkWidget *, Nix))))
									break;

							if (Nix < params->array->len) {
								gtk_widget_destroy(g_array_index(params->array, GtkWidget *, Nix));
								g_array_remove_index_fast(params->array, Nix);
							}
						}
						else
							gtk_widget_destroy(params->toplevel_menu);

						g_free(item_name);

						g_match_info_free(match_info);
					}
				}
			}
			else
			if (!strncmp("refill", str, 6)) {
				GList *ll;
				for (ll = gtk_container_get_children(GTK_CONTAINER(params->toplevel_menu)) ; ll; ll = g_list_delete_link(ll, ll))
					if (ll->data)
						gtk_widget_destroy(ll->data);
			}
			else
			if (!strncmp("append", str, 6)) {
				GRegex *regex = g_regex_new("^append \"([^\"]*)\" \"([^\"]*)\"$", 0, 0, NULL);

				if (regex) {
					GMatchInfo *match_info = NULL;

					g_regex_match(regex, str, 0, &match_info);

					if (match_info) {
						char *sibling_name = g_match_info_fetch(match_info, 1);
						char *stock_name = g_match_info_fetch(match_info, 2);

						if (sibling_name) {
							int Nix;

							for (Nix = 0 ; Nix < params->array->len ; Nix++)
								if (!g_strcmp0(sibling_name, _hmv_private_menu_item_get_label(g_array_index(params->array, GtkWidget *, Nix))))
									break;

							if (Nix < params->array->len) {
								GtkWidget *new_menu_item = NULL;
								int Nix1 = 0;
								GtkContainer *shell = GTK_CONTAINER(gtk_widget_get_parent(g_array_index(params->array, GtkWidget *, Nix)));
								GList *ll_children = gtk_container_get_children(shell), *ll_itr;

								for (ll_itr = ll_children ; ll_itr ; ll_itr = ll_itr->next)
									if (ll_itr->data) {
										if (ll_itr->data == g_array_index(params->array, GtkWidget *, Nix)) {
											new_menu_item = gtk_image_menu_item_new_from_stock(stock_name, NULL);
											gtk_widget_show(new_menu_item);
//											gtk_container_add(GTK_CONTAINER(shell), new_menu_item);
											gtk_menu_shell_insert(GTK_MENU_SHELL(shell), new_menu_item, Nix1 + 1);
											g_array_append_val(params->array, new_menu_item);
											break;
										}
										Nix1++;
									}
										
							}
						}

						g_free(sibling_name);
						g_free(stock_name);

						g_match_info_free(match_info);
					}
				}
			}
			else
			if (!strncmp("help", str, 4))
				g_print(
					"ls\n"
					"refill\n"
					"set-label \"Name\" \"New Name\"\n"
					"set \"Name\" \"property\" TRUE|FALSE\n"
					"kill\n"
					"kill \"Name\"\n"
					"append \"Sibling\" \"stock-name\"\n"
					"help\n");
			g_free(str);
		}

	return TRUE;
}

static void
menu_destroyed(MenuDestroyedParams *params, GtkMenu *stale_pointer)
{
	g_source_remove(params->gio_stdin_read_id);
	g_array_free(params->array, TRUE);
	g_io_channel_unref(params->gio_stdin);
	g_free(params);
}

static void
set_up_menu_changes(GtkWidget *widget)
{
	MenuDestroyedParams *params = g_new0(MenuDestroyedParams, 1);

	params->gio_stdin = g_io_channel_unix_new(0);
	params->array = g_array_new(FALSE, TRUE, sizeof(GtkWidget *));
	params->gio_stdin_read_id = g_io_add_watch(params->gio_stdin, G_IO_IN, (GIOFunc)stuff_on_stdin, params);
	params->toplevel_menu = widget;

	add_items(widget, params->array);

	g_object_weak_ref(G_OBJECT(widget), (GWeakNotify)menu_destroyed, params);
}

static GtkWidget *
make_menu(GtkWidget **p_menu_item)
{
	GtkContainer *toplevel;
	GtkContainer *menu;
	GtkContainer *backup, *backup1, *backup2;
	GtkWidget *item, *item1, *item2, *item3, *item4;
	GtkWidget *label = NULL;

	menu = GTK_CONTAINER(gtk_menu_new());
	gtk_widget_set_name(GTK_WIDGET(menu), "toplevel");
	gtk_container_add(menu, item = gtk_check_menu_item_new_with_label("<b>Bold</b> and <i>Italic</i>"));
	g_object_set_data(G_OBJECT(item), "debug-name", "Marked-up item");
	get_first_label_found(item, &label);
	if (label)
		g_object_set(G_OBJECT(label), "use-markup", TRUE, NULL);
	gtk_container_add(menu, item = gtk_image_menu_item_new_from_stock(GTK_STOCK_ABOUT, NULL));

	toplevel = menu;
		menu = GTK_CONTAINER(gtk_menu_new());
		gtk_widget_set_name(GTK_WIDGET(menu), "about_submenu");
		gtk_container_add(menu, gtk_image_menu_item_new_from_stock(GTK_STOCK_CONVERT, NULL));
//		gtk_container_add(menu, gtk_menu_item_new_with_label("This Is A Menu Item Whose Label Is Designed To Exceed The Possible Width Of The Column It Is In"));
		gtk_container_add(menu, gtk_separator_menu_item_new());
		gtk_container_add(menu, item1 = gtk_image_menu_item_new_from_stock(GTK_STOCK_COPY, NULL));

		backup = menu;
			menu = GTK_CONTAINER(gtk_menu_new());
			gtk_widget_set_name(GTK_WIDGET(menu), "copy_submenu");
			gtk_container_add(menu, gtk_image_menu_item_new_from_stock(GTK_STOCK_CONNECT, NULL));
			gtk_container_add(menu, item2 = gtk_radio_menu_item_new_with_mnemonic(NULL, "Radio Item 1"));
			gtk_container_add(menu, gtk_separator_menu_item_new());
			gtk_container_add(menu, gtk_radio_menu_item_new_with_mnemonic_from_widget(GTK_RADIO_MENU_ITEM(item2), "Radio Item 2"));
			gtk_container_add(menu, gtk_radio_menu_item_new_with_mnemonic_from_widget(GTK_RADIO_MENU_ITEM(item2), "Radio Item 3"));
			gtk_container_add(menu, item3 = gtk_image_menu_item_new_from_stock(GTK_STOCK_CUT, NULL));

			backup1 = menu;
				menu = GTK_CONTAINER(gtk_menu_new());
				gtk_widget_set_name(GTK_WIDGET(menu), "cut_submenu");
				gtk_container_add(menu, gtk_image_menu_item_new_from_stock(GTK_STOCK_DELETE, NULL));
				gtk_container_add(menu, gtk_separator_menu_item_new());
				gtk_container_add(menu, item4 = gtk_image_menu_item_new_from_stock(GTK_STOCK_EDIT, NULL));

				backup2 = menu;
					menu = GTK_CONTAINER(gtk_menu_new());
					gtk_widget_set_name(GTK_WIDGET(menu), "edit_submenu");
					gtk_container_add(menu, gtk_image_menu_item_new_from_stock(GTK_STOCK_FILE, NULL));
					gtk_container_add(menu, gtk_separator_menu_item_new());
					gtk_container_add(menu, gtk_image_menu_item_new_from_stock(GTK_STOCK_FIND, NULL));
					gtk_container_add(menu, gtk_image_menu_item_new_from_stock(GTK_STOCK_FIND_AND_REPLACE, NULL));
					gtk_container_add(menu, gtk_separator_menu_item_new());
					gtk_container_add(menu, gtk_image_menu_item_new_from_stock(GTK_STOCK_FLOPPY, NULL));
					gtk_menu_item_set_submenu(GTK_MENU_ITEM(item4), GTK_WIDGET(menu));
				menu = backup2;
				gtk_container_add(menu, gtk_image_menu_item_new_from_stock(GTK_STOCK_EXECUTE, NULL));
				gtk_menu_item_set_submenu(GTK_MENU_ITEM(item3), GTK_WIDGET(menu));
			menu = backup1;
			gtk_container_add(menu, gtk_image_menu_item_new_from_stock(GTK_STOCK_DIRECTORY, NULL));
			gtk_menu_item_set_submenu(GTK_MENU_ITEM(item1), GTK_WIDGET(menu));
		menu = backup;
		gtk_container_add(menu, gtk_image_menu_item_new_from_stock(GTK_STOCK_DISCONNECT, NULL));
		gtk_menu_item_set_submenu(GTK_MENU_ITEM(item), GTK_WIDGET(menu));
	menu = toplevel;
	gtk_container_add(menu, gtk_image_menu_item_new_from_stock(GTK_STOCK_BOLD, NULL));
	gtk_container_add(menu, gtk_separator_menu_item_new());
	gtk_container_add(menu, gtk_image_menu_item_new_from_stock(GTK_STOCK_CANCEL, NULL));
	gtk_container_add(menu, gtk_separator_menu_item_new());
	gtk_container_add(menu, gtk_image_menu_item_new_from_stock(GTK_STOCK_CDROM, NULL));
	gtk_container_add(menu, gtk_check_menu_item_new_with_label("Check Menu Item"));
	gtk_container_add(menu, item = gtk_image_menu_item_new_with_label("Image Menu Item"));
	g_object_set(G_OBJECT(item),
		"image", g_object_new(GTK_TYPE_IMAGE, "visible", TRUE, "file", "/usr/share/icons/hicolor/24x24/hildon/chat_smiley_angry.png", NULL), 
		NULL);
	gtk_container_add(menu, gtk_image_menu_item_new_from_stock(GTK_STOCK_CLEAR, NULL));
	gtk_container_add(menu, gtk_image_menu_item_new_from_stock(GTK_STOCK_CLOSE, NULL));
	gtk_container_add(menu, item = gtk_image_menu_item_new_from_stock(GTK_STOCK_COLOR_PICKER, NULL));

	toplevel = menu;
		menu = GTK_CONTAINER(gtk_menu_new());
		gtk_widget_set_name(GTK_WIDGET(menu), "color_picker_submenu");
		gtk_container_add(menu, gtk_image_menu_item_new_from_stock(GTK_STOCK_ADD, NULL));
		gtk_container_add(menu, gtk_separator_menu_item_new());
		gtk_container_add(menu, gtk_check_menu_item_new_with_label("Check Menu Item 2"));
		gtk_container_add(menu, gtk_image_menu_item_new_from_stock(GTK_STOCK_APPLY, NULL));
		gtk_menu_item_set_submenu(GTK_MENU_ITEM(item), GTK_WIDGET(menu));
	menu = toplevel;
	gtk_container_add(menu, gtk_image_menu_item_new_from_stock(GTK_STOCK_DND, NULL));

	gtk_widget_show_all(GTK_WIDGET(toplevel));

	return GTK_WIDGET(toplevel);
}

int
main(int argc, char **argv)
{
	GtkWidget *menu_item;
	GtkMenu *menu;

	gtk_init(&argc, &argv);

	menu = GTK_MENU(make_menu(&menu_item));
	g_print("main: created menu\n");

	set_up_menu_changes(GTK_WIDGET(menu));

	he_menu_view_popup(menu, NULL);

	gtk_widget_destroy(menu);

	gtk_main();

	return 0;
}
