<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="text"/>

<xsl:variable name="RESPONSE" select="'Response'"/>
<xsl:variable name="REQUEST" select="'Request'"/>
<xsl:variable name="PARAMS" select="'Params'"/>
<xsl:variable name="STRING" select="'string'"/>
<xsl:variable name="NUMBER" select="'number'"/>


<xsl:include href="errors.xsl"/>

<xsl:template match="/">
 <xsl:apply-templates select="/data/rsp[@stat='ok']"/>
 <xsl:apply-templates select="/data/rsp[@stat='fail']"/>
</xsl:template>

<xsl:template match="rsp[@stat='ok']">
    <xsl:element name="{$RESPONSE}">
        <xsl:attribute name="class">news</xsl:attribute>
        <xsl:attribute name="function">getNews</xsl:attribute>

        <xsl:choose>

            <xsl:when test="/data/Request/Params/string[@name = 'newsType'] = 'photo'">
                <xsl:element name="{$REQUEST}">
                    <xsl:attribute name="class">news</xsl:attribute>
                    <xsl:attribute name="function">getListNewsPhotos</xsl:attribute>
                    <xsl:copy-of select="/data/Request/Params"/>
                </xsl:element>
            </xsl:when>

            <xsl:when test="/data/Request/Params/string[@name = 'newsType'] = 'comment'">
                <xsl:element name="{$REQUEST}">
                    <xsl:attribute name="class">news</xsl:attribute>
                    <xsl:attribute name="function">getListNewsComments</xsl:attribute>
                    <xsl:copy-of select="/data/Request/Params"/>
                </xsl:element>
                <xsl:element name="{$REQUEST}">
                    <xsl:attribute name="class">news</xsl:attribute>
                    <xsl:attribute name="function">getListNewsComments2</xsl:attribute>
                    <xsl:copy-of select="/data/Request/Params"/>
                </xsl:element>

            </xsl:when>

            <xsl:otherwise>
            </xsl:otherwise>

        </xsl:choose>
    </xsl:element> 
</xsl:template>
</xsl:stylesheet>
