<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="text" indent="yes"/>
<xsl:param name="MID"/>  
<xsl:param name="SID"/>  
<xsl:param name="SECRET"/>

<xsl:variable name="URL" select="'url'"/>
<xsl:variable name="SIG" select="'sig'"/>
<xsl:variable name="INNER_REQUEST" select="'InnerRequest'"/>
<xsl:variable name="REQUEST" select="'Request'"/>
<xsl:variable name="RESPONSE" select="'Response'"/>
<xsl:variable name="PARAMS" select="'Params'"/>
<xsl:variable name="STRING" select="'string'"/>
<xsl:variable name="NUMBER" select="'number'"/>
<xsl:variable name="STRUCT" select="'struct'"/>
<xsl:variable name="ARRAY" select="'array'"/>
<xsl:variable name="IMG" select="'img'"/>

<xsl:include href="errors.xsl"/>

<xsl:template match="/data/rsp[@stat='ok']">
    <xsl:element name="{$RESPONSE}">
        <xsl:attribute name="class">photos</xsl:attribute>
        <xsl:attribute name="function">getListUserPhotos</xsl:attribute>
        <xsl:element name="{$PARAMS}">

            <xsl:element name="{$ARRAY}">
                <xsl:attribute name="name">photosList</xsl:attribute>
                <xsl:attribute name="page">
                    <xsl:value-of select="photos/@page"/>
                </xsl:attribute>
                <xsl:attribute name="pageSize">
                    <xsl:value-of select="photos/@perpage"/>
                </xsl:attribute>
                <xsl:attribute name="quantity">
                    <xsl:value-of select="count(photos/photo)"/>
                </xsl:attribute>

                <xsl:for-each select="photos/photo">
                    <xsl:element name="{$STRUCT}">
                        <xsl:attribute name="name">photo</xsl:attribute>
                        <xsl:attribute name="id">
                            <xsl:text>fl</xsl:text>
                        <xsl:value-of select="@id"/>
                        </xsl:attribute>

		            <xsl:attribute name="ownerId">
		                <xsl:text>fl</xsl:text>
                                <xsl:value-of select="@owner"/>
                            </xsl:attribute>

		            <xsl:attribute name="albumId">
		                <xsl:text>fl</xsl:text>
                                <xsl:value-of select="@id"/>
                            </xsl:attribute>


                        <xsl:element name="{$STRING}">
                           <xsl:attribute name="name">urlSmall</xsl:attribute>
                           <xsl:value-of select="@url_t"/>
                        </xsl:element>

                        <xsl:element name="{$STRING}">
                            <xsl:attribute name="name">urlBig</xsl:attribute>http://farm<xsl:value-of select="@farm"/>.static.flickr.com/<xsl:value-of select="@server"/>/<xsl:value-of select="@id"/>_<xsl:value-of select="@secret"/>.jpg</xsl:element>

                        <xsl:element name="{$NUMBER}">
                            <xsl:attribute name="name">created</xsl:attribute>
                            <xsl:value-of select="@dateupload"/>
                        </xsl:element>
                    </xsl:element>
                </xsl:for-each>
            </xsl:element> 

        </xsl:element> 
    </xsl:element>
</xsl:template>
</xsl:stylesheet>
