<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
	 xmlns:df="http://api.facebook.com/1.0/" exclude-result-prefixes="df">
<xsl:output method="text"/>

<xsl:variable name="REQUEST" select="'Request'"/>
<xsl:variable name="RESPONSE" select="'Response'"/>
<xsl:variable name="PARAMS" select="'Params'"/>
<xsl:variable name="STRING" select="'string'"/>
<xsl:variable name="NUMBER" select="'number'"/>
<xsl:variable name="STRUCT" select="'struct'"/>
<xsl:variable name="ARRAY" select="'array'"/>

<xsl:include href="errors.xsl"/>

<xsl:template match="/">
 <xsl:apply-templates select="/data/df:error_response"/>
 <xsl:apply-templates select="/data/info_response"/>
 <xsl:apply-templates select="/data/df:fql_multiquery_response"/>
  <xsl:apply-templates select="/data/response"/>
</xsl:template>

<xsl:template match="response">
    <xsl:choose>
        <xsl:when test="contains(/data/Request/Params/string[@name='newsType'],'photo')">
            <xsl:element name="{$REQUEST}">
                <xsl:attribute name="class">news</xsl:attribute>
                <xsl:attribute name="function">getListNewsPhotos</xsl:attribute>
                <xsl:copy-of select="/data/Request/Params"/>
            </xsl:element>
        </xsl:when>
        <xsl:otherwise>
            <xsl:element name="{$RESPONSE}">
                <xsl:attribute name="class">news</xsl:attribute>
                <xsl:attribute name="function">getListNews</xsl:attribute>
                <xsl:element name="{$PARAMS}">
                    <xsl:element name="{$ARRAY}">
                        <xsl:attribute name="name">newsList</xsl:attribute>
                        <xsl:attribute name="page">
                                <xsl:value-of select="/data/Request/Params/number[@name='page']"/> 
                        </xsl:attribute>

                        <xsl:attribute name="pageSize">
                                <xsl:value-of select="/data/Request/Params/number[@name='pageSize']"/> 
                        </xsl:attribute>

                        <xsl:attribute name="newsType">
                                <xsl:value-of select="/data/Request/Params/string[@name='newsType']"/>
                        </xsl:attribute>

                        <xsl:attribute name="quantity">
                                <xsl:value-of select="'0'"/>
                        </xsl:attribute>
                    </xsl:element> 

                </xsl:element> 
            </xsl:element>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template match="df:fql_multiquery_response">
    <xsl:choose>
        <xsl:when test="contains(/data/Request/Params/string[@name='newsType'],'photo')">
            <xsl:element name="{$RESPONSE}">
                <xsl:attribute name="class">news</xsl:attribute>
                <xsl:attribute name="function">getListNews</xsl:attribute>
                <xsl:element name="{$PARAMS}">
                    <xsl:element name="{$ARRAY}">
                        <xsl:attribute name="name">newsList</xsl:attribute>
                        <xsl:attribute name="page">
                                <xsl:value-of select="/data/Request/Params/number[@name='page']"/> 
                        </xsl:attribute>
                        <xsl:attribute name="pageSize">
                                <xsl:value-of select="/data/Request/Params/number[@name='pageSize']"/> 
                        </xsl:attribute>
                        <xsl:attribute name="newsType">
                                <xsl:value-of select="/data/Request/Params/string[@name='newsType']"/>
                        </xsl:attribute>
                        <xsl:attribute name="quantity">
                                <xsl:value-of select="count(/data/df:fql_multiquery_response/df:fql_result[df:name='photos']/df:fql_result_set/df:photo)"/>
                        </xsl:attribute>
                        <xsl:apply-templates select="/data/df:fql_multiquery_response/df:fql_result[df:name='photos']/df:fql_result_set/df:photo"/>
                    </xsl:element> 
                </xsl:element> 
            </xsl:element>
        </xsl:when>
        <xsl:otherwise>
            <xsl:element name="{$RESPONSE}">
                <xsl:attribute name="class">news</xsl:attribute>
                <xsl:attribute name="function">getListNews</xsl:attribute>
                <xsl:element name="{$PARAMS}">
                    <xsl:element name="{$ARRAY}">
                        <xsl:attribute name="name">newsList</xsl:attribute>
                        <xsl:attribute name="page">
                                <xsl:value-of select="/data/Request/Params/number[@name='page']"/> 
                        </xsl:attribute>

                        <xsl:attribute name="pageSize">
                                <xsl:value-of select="/data/Request/Params/number[@name='pageSize']"/> 
                        </xsl:attribute>

                        <xsl:attribute name="newsType">
                                <xsl:value-of select="/data/Request/Params/string[@name='newsType']"/>
                        </xsl:attribute>

                        <xsl:attribute name="quantity">
                                <xsl:value-of select="'0'"/>
                        </xsl:attribute>
                    </xsl:element> 

                </xsl:element> 
            </xsl:element>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>
<xsl:template match="df:photo">
    <xsl:variable name="owner" select="df:owner"/>
    <xsl:variable name="aid" select="df:aid"/>
    <xsl:element name="{$STRUCT}">
        <xsl:attribute name="name">news</xsl:attribute>
        <xsl:element name="{$STRING}">
           <xsl:attribute name="name">authorId</xsl:attribute>
            <xsl:text>fb</xsl:text>
           <xsl:value-of select="df:owner"/>
        </xsl:element>
        <xsl:element name="{$STRING}">
           <xsl:attribute name="name">authorName</xsl:attribute>
           <xsl:value-of select="/data/df:fql_multiquery_response/df:fql_result[df:name='authors']/df:fql_result_set/df:user[df:uid=$owner]/df:name"/>
        </xsl:element>
        <xsl:element name="{$NUMBER}">
            <xsl:attribute name="name">created</xsl:attribute>
            <xsl:value-of select="df:created"/>
        </xsl:element>
        <xsl:element name="{$STRUCT}">
            <xsl:attribute name="name">attachment</xsl:attribute>
            <xsl:attribute name="type">
                <xsl:text>image</xsl:text>
            </xsl:attribute>
            <xsl:attribute name="id">
                <xsl:text>fb</xsl:text>
                <xsl:value-of select="df:pid"/>
                <xsl:text>@</xsl:text>
                <xsl:value-of select="df:object_id"/>
            </xsl:attribute>
            <xsl:attribute name="ownerId">
                <xsl:text>fb</xsl:text>
                <xsl:value-of select="df:owner"/>
            </xsl:attribute>

            <xsl:element name="{$STRING}">
               <xsl:attribute name="name">urlSmall</xsl:attribute>
               <xsl:value-of select="df:src"/>
            </xsl:element>

            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">urlBig</xsl:attribute>
                <xsl:value-of select="df:src_big"/>
            </xsl:element>

            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">text</xsl:attribute>
                <xsl:value-of select="df:caption"/>
            </xsl:element>
            
            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">albumId</xsl:attribute>
                <xsl:text>fb</xsl:text>
		            <xsl:value-of select="df:aid"/>
                <xsl:text>@</xsl:text>
               <xsl:value-of select="/data/df:fql_multiquery_response/df:fql_result[df:name='albums']/df:fql_result_set/df:album[df:aid=$aid]/df:object_id"/>
            </xsl:element>
        </xsl:element>
    </xsl:element>
</xsl:template>
</xsl:stylesheet>
