<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
	 xmlns:df="http://api.facebook.com/1.0/" exclude-result-prefixes="df">
<xsl:output method="text"/>

<xsl:variable name="REQUEST" select="'Request'"/>
<xsl:variable name="RESPONSE" select="'Response'"/>
<xsl:variable name="PARAMS" select="'Params'"/>
<xsl:variable name="STRING" select="'string'"/>

<xsl:include href="errors.xsl"/>

<xsl:template match="/">
 <xsl:apply-templates select="/data/df:error_response"/>
 <xsl:apply-templates select="/data/info_response"/>
 <xsl:apply-templates select="/data/df:fql_query_response"/>
  <xsl:apply-templates select="/data/response"/>
</xsl:template>

<xsl:template match="response">
    <xsl:choose>
        <xsl:when test="/data/response/error">
            <xsl:variable name="ERROR_CODE" select="'1705'"/>  
            <xsl:element name="{$RESPONSE}">
                <xsl:attribute name="class">systemMessages</xsl:attribute>
                <xsl:attribute name="function">errorMessage</xsl:attribute>
                <xsl:element name="{$PARAMS}">
                    <xsl:element name="{$STRING}">
                        <xsl:attribute name="name">moduleName</xsl:attribute>
                        <xsl:text>facebook</xsl:text>
                    </xsl:element> 
                    <xsl:element name="{$STRING}">
                        <xsl:attribute name="name">code</xsl:attribute>
                        <xsl:if test="document('errors.xml')//mysocials_errors/error[server_code=$ERROR_CODE]">
                            <xsl:value-of select="document('errors.xml')//mysocials_errors/error[server_code=$ERROR_CODE]/code"/>
                        </xsl:if>
                    </xsl:element> 
                    <xsl:element name="{$STRING}">
                        <xsl:attribute name="name">text</xsl:attribute>
                        <xsl:value-of select="document('errors.xml')//mysocials_errors/error[server_code=$ERROR_CODE]/message"/>
                    </xsl:element> 
                    <xsl:element name="{$STRING}">
                        <xsl:attribute name="name">comment</xsl:attribute>
                        <xsl:value-of select="/data/response/error/message"/>
                    </xsl:element>
                    <xsl:element name="{$STRING}">
                        <xsl:attribute name="name">log</xsl:attribute>
                        <xsl:copy-of select="/data/response/error/type"/>
                    </xsl:element>
                </xsl:element>
            </xsl:element>
        </xsl:when>
        <xsl:otherwise>
            <xsl:element name="{$RESPONSE}">
                <xsl:attribute name="class">photo</xsl:attribute>
                <xsl:attribute name="function">uploadPhoto</xsl:attribute>
                <xsl:element name="{$PARAMS}">
                    <xsl:choose>
                        <xsl:when test="/data/Request/Params/string[@name='albumId']">
                            <xsl:element name="{$STRING}">
                                <xsl:attribute name="name">albumId</xsl:attribute>
                                <xsl:value-of select="/data/Request/Params/string[@name='albumId']"/>
                            </xsl:element>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:element name="{$REQUEST}">
                                <xsl:attribute name="class">photos</xsl:attribute>
                                <xsl:attribute name="function">getAlbumId</xsl:attribute>
                                <xsl:element name="{$PARAMS}">
                                    <xsl:element name="{$STRING}">
                                        <xsl:attribute name="name">object_id</xsl:attribute>
                                        <xsl:value-of select="/data/Request/Params/string[@name='object_id']"/>
                                    </xsl:element>
                                </xsl:element>
                            </xsl:element>
                        </xsl:otherwise>
                    </xsl:choose>
                    <xsl:element name="{$REQUEST}">
                        <xsl:attribute name="class">photos</xsl:attribute>
                        <xsl:attribute name="function">getPhotoId</xsl:attribute>
                        <xsl:element name="{$PARAMS}">
                            <xsl:element name="{$STRING}">
                                <xsl:attribute name="name">object_id</xsl:attribute>
                                <xsl:value-of select="/data/response/id"/>
                            </xsl:element>
                        </xsl:element>
                    </xsl:element>
                </xsl:element>
            </xsl:element>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template match="df:fql_query_response">
    <xsl:element name="{$REQUEST}">
        <xsl:attribute name="class">photos</xsl:attribute>
        <xsl:attribute name="function">uploadPhotoLast</xsl:attribute>
        <xsl:element name="{$PARAMS}">
            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">object_id</xsl:attribute>
                <xsl:value-of select="/data/df:fql_query_response/df:album/df:object_id/."/>
            </xsl:element>
            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">albumId</xsl:attribute>
                <xsl:value-of select="/data/Request/Params/string[@name = 'albumId']"/>
            </xsl:element>
            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">file</xsl:attribute>
                <xsl:value-of select="/data/Request/Params/string[@name='file']"/>
            </xsl:element>
            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">fileName</xsl:attribute>
                <xsl:value-of select="/data/Request/Params/string[@name='fileName']"/>
            </xsl:element>
            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">description</xsl:attribute>
                <xsl:value-of select="/data/Request/Params/string[@name = 'description']"/>
            </xsl:element>
        </xsl:element>
    </xsl:element>
</xsl:template>

</xsl:stylesheet>
