<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
	 xmlns:df="http://api.facebook.com/1.0/" exclude-result-prefixes="df">
<xsl:output method="text"/>
<xsl:param name="MID"/>  
<xsl:param name="SID"/>  
<xsl:param name="SECRET"/>

<xsl:param name="LIMIT">100000</xsl:param>
<xsl:variable name="URL" select="'url'"/>
<xsl:variable name="SIG" select="'sig'"/>
<xsl:variable name="INNER_REQUEST" select="'InnerRequest'"/>
<xsl:variable name="REQUEST" select="'Request'"/>
<xsl:variable name="RESPONSE" select="'Response'"/>
<xsl:variable name="PARAMS" select="'Params'"/>
<xsl:variable name="STRING" select="'string'"/>
<xsl:variable name="NUMBER" select="'number'"/>
<xsl:variable name="STRUCT" select="'struct'"/>
<xsl:variable name="ARRAY" select="'array'"/>
<xsl:variable name="IMG" select="'img'"/>

<xsl:variable name="FUNCTION" select="/Request/@function"/>  

<xsl:include href="errors.xsl"/>

<xsl:template match="/">
 <xsl:apply-templates select="/data/df:error_response"/>
 <xsl:apply-templates select="/data/info_response"/>
 <xsl:apply-templates select="/data/df:fql_query_response"/>
</xsl:template>

<xsl:template match="/data/df:fql_query_response">

    <xsl:element name="{$RESPONSE}">
        <xsl:attribute name="class">photos</xsl:attribute>
        <xsl:attribute name="function">
            <xsl:value-of select="/data/Request/@function"/>
        </xsl:attribute>
        <xsl:element name="{$PARAMS}">
            <xsl:element name="{$ARRAY}">
                <xsl:attribute name="name">photosList</xsl:attribute>
                <xsl:attribute name="page">
                    <xsl:choose>
                        <xsl:when test="/data/Request/Params/number[@name='page']">
                            <xsl:value-of select="/data/Request/Params/number[@name='page']"/> 
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="'1'"/> 
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:attribute>

                <xsl:attribute name="pageSize">
                    <xsl:choose>
                        <xsl:when test="/data/Request/Params/number[@name='pageSize']">
                            <xsl:value-of select="/data/Request/Params/number[@name='pageSize']"/> 
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="$LIMIT"/> 
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:attribute>

                <xsl:attribute name="quantity">
                    <xsl:value-of select="count(/data/df:fql_query_response/df:photo)"/>
                </xsl:attribute>
                
                <xsl:apply-templates select="/data/df:fql_query_response/df:photo"/>
            </xsl:element> 

        </xsl:element> 
    </xsl:element> 
</xsl:template>


<xsl:template match="df:photo">

    <xsl:element name="{$STRUCT}">
        <xsl:attribute name="name">photo</xsl:attribute>
        <xsl:attribute name="id">
            <xsl:text>fb</xsl:text>
        <xsl:value-of select="df:pid"/>
        </xsl:attribute>

        <xsl:element name="{$STRING}">
            <xsl:attribute name="name">albumId</xsl:attribute>
            <xsl:text>fb</xsl:text>
            <xsl:value-of select="df:aid"/>
        </xsl:element>

        <xsl:element name="{$STRING}">
            <xsl:attribute name="name">ownerId</xsl:attribute>
            <xsl:text>fb</xsl:text>
            <xsl:value-of select="df:owner"/>
        </xsl:element>

        <xsl:element name="{$STRING}">
           <xsl:attribute name="name">urlSmall</xsl:attribute>
           <xsl:value-of select="df:src"/>
        </xsl:element>

        <xsl:element name="{$STRING}">
            <xsl:attribute name="name">urlBig</xsl:attribute>
            <xsl:value-of select="df:src_big"/>
        </xsl:element>

        <xsl:element name="{$NUMBER}">
            <xsl:attribute name="name">created</xsl:attribute>
            <xsl:value-of select="df:created"/>
        </xsl:element>

        <xsl:element name="{$NUMBER}">
            <xsl:attribute name="name">modified</xsl:attribute>
            <xsl:value-of select="df:modified"/>
        </xsl:element>
    </xsl:element>
</xsl:template>
</xsl:stylesheet>
