# norootforbuild  

%define revision 6

%define realname	libfacebook
%define libname libmsafb
Name:		libmsafb0
Version:	0.3
Release:	%{revision}
Summary:	Library for using main functions of API facebook.com
Group:		System/Libraries
URL:		http://oss.fruct.org/wiki/MySocials
Source0:	%{realname}_%{version}-%{revision}.tar.gz
License:	GPLv2+
BuildRoot:	%{_tmppath}/%{name}-root
AutoReqProv:    on

BuildRequires:  pkgconfig(libcurl) >= 7.16.2-1
BuildRequires:  pkgconfig(libxml-2.0) >= 2.6.32
BuildRequires:  pkgconfig(gconf-2.0)
BuildRequires:  pkgconfig(libxslt)
Requires: libxml2


# curl and gconf
%if "0%{?meego_version}" != "0"
Requires:  libcurl >= 7.16.2-1
Requires:  GConf-dbus
%endif

%if 0%{?fedora_version}
Requires:  libcurl
Requires:  GConf2
%endif

%if 0%{?mdkversion}
%ifarch x86_64
Requires:  lib64curl4
%else
Requires:  libcurl4
%endif
Requires:  GConf2
%endif

%if 0%{?suse_version}
Requires:  libcurl4
Requires:  gconf2
%endif


# xslt
%if 0%{?mdkversion}
%ifarch x86_64
Requires: lib64xslt1
%else
Requires:  libxslt1
%endif
BuildRequires:  polkit-gnome
Requires:  polkit-gnome
%else
Requires: libxslt
%endif

%if 0%{?mdkversion}
BuildRequires:  polkit-gnome
%endif

# mysocials
BuildRequires:  mysocials-dev
Requires:       webauth


BuildRequires: pkgconfig(dbus-glib-1)
BuildRequires:  libjson0-devel
Requires:  libjson0

# skip-check-libtool-deps

%description
The library allows editing user profile data, receiving contacts (friend lists),
and sending, receiving messages. The example of using libmsafb can
be found at http://maemo.org/packages/view/mysocials-driver-console/

%package devel
Summary:	Development headers and libraries for %{name}
Group:		Development/Libraries
Requires:	%{name} = %{version}

%description devel
The library allows editing user profile data, receiving contacts (friend lists),
and sending, receiving messages. The example of using libmsafb can
be found at http://maemo.org/packages/view/mysocials-driver-console/

%prep
%setup -q -n %{realname}-%{version}

%build
./autogen.sh

#%configure --libdir=%{_libdir}/%{realname}
%configure --disable-static --with-pic
%{__make} %{?_smp_flags} all

%check
%{__make} %{?_smp_flags} check

%install
%{__make} DESTDIR=$RPM_BUILD_ROOT install libdir=%{_libdir} mandir=%{_mandir}

%clean
#rm -rf %{buildroot}

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%defattr(-,root,root)
%{_libdir}/lib*.so.*
%dir %{_datadir}/msa
%dir %{_datadir}/msa/drivers
%dir %{_datadir}/msa/drivers/facebook
%{_datadir}/msa/drivers/facebook/lib*.so
%{_datadir}/msa/drivers/facebook/*.pem
%{_datadir}/msa/drivers/facebook/*.xsl
%{_datadir}/msa/drivers/facebook/*.xml

%files devel
%defattr(-,root,root)
%{_libdir}/lib*.so
%{_libdir}/lib*.*a
%{_libdir}/pkgconfig/*.pc


%changelog
* Thu Jul 22 2010 Pavel Shiryaev <shiryaev@cs.karelia.ru>
+ 
- 