#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <ctype.h>
#include <string.h>
#include <stdbool.h>
#include <time.h>

#include "ctf_io.h"

char*
ctf_read_data(const char *var_name, const char *data_file_name) {
    int    fd_data_file;
    size_t file_size = 0;
    char   *file_buf;
    char   *pos = NULL;
    char   *data;
    int    i = 0;
    struct stat st;

    if(var_name == NULL || data_file_name == NULL) return NULL;

    if(stat(data_file_name, &st) == -1) {
        return NULL;
    }
    file_size = st.st_size;

    if((file_buf = malloc(file_size + 1)) == NULL) {
        return NULL;
    }
    if((fd_data_file = open(data_file_name, O_RDONLY)) == -1) {
        return NULL;
    }
    if(read(fd_data_file, file_buf, file_size) == -1) {
        return NULL;
    }

    if((pos = strstr(file_buf, var_name)) == NULL) {
        return NULL;
    }

    while(*pos != '=' && ++pos);
    pos++; /* skip '=' sign */
    while(isspace(*pos) && ++pos);

    if((data = malloc(file_size)) == NULL) {
        return NULL;
    }

    memset(data, 0, file_size);
    while(pos && !isspace(*pos) && i < file_size) {
        data[i] = *pos;
        ++i; ++pos;
    }

    (void)close(fd_data_file);
    free(file_buf);

    return data;
}

void
ctf_write_stat(int passed, int failed, int total, const char *stat_file_name) {
    int    stat_file_fd;
    char   *userlogin;
    bool   clean_login = false;
    bool   write_head = false;
    time_t now = time(NULL);
    struct tm tm_now;
    char   time_str[TIME_STR_LENGTH];
    char   stat[STAT_STR_LENGTH];

    if(stat_file_name == NULL) return;

    if(access(stat_file_name, F_OK) == -1) {
	write_head = true;
    }
    if((stat_file_fd = open(stat_file_name, O_WRONLY | O_APPEND | O_CREAT)) == -1) {
	return;
    }

    /* if((userlogin = getlogin()) == NULL) { */
    if((userlogin = getenv("USER")) == NULL) {
	userlogin = malloc(strlen(DEFAULT_LOGIN) + 1);
	strncpy(userlogin, DEFAULT_LOGIN, strlen(DEFAULT_LOGIN));
	clean_login = true;
    }

    localtime_r(&now, &tm_now);
    strftime(time_str, TIME_STR_LENGTH, "%d/%m/%y"STAT_FILE_FIELD_SEPARATOR"%H:%M:%S", &tm_now);
    if(write_head) {
	sprintf(stat, "%s\n%s"STAT_FILE_FIELD_SEPARATOR"%s"STAT_FILE_FIELD_SEPARATOR
	    "%d"STAT_FILE_FIELD_SEPARATOR"%d"STAT_FILE_FIELD_SEPARATOR"%d\n",
	    HEAD, time_str, userlogin, passed, failed, total);
    } else {
	sprintf(stat, "%s"STAT_FILE_FIELD_SEPARATOR"%s"STAT_FILE_FIELD_SEPARATOR
	    "%d"STAT_FILE_FIELD_SEPARATOR"%d"STAT_FILE_FIELD_SEPARATOR"%d\n",
	    time_str, userlogin, passed, failed, total);
    }
    
    if(write(stat_file_fd, stat, strlen(stat)) == -1) {
	return;
    }

    if(close(stat_file_fd) == -1) {
	return;
    }
    if(clean_login) free(userlogin);
}
