#define CTF_LOG_FORMAT_USE_TIME
#define CTF_THROW_EXIT

#include "CTF/src/ctf.h"
#include <driver.h>
#include <facebook.h>
#include <parser.h>
#include <mysocials_driver.h>
#include <glib.h>

#define XML_RESPONSE_FILE "response.xml"
#define REQUEST_UPDATE_PROFILE "<Request class=\"profile\" function = \"updateProfile\"><Params></Params></Request>"
#define REQUEST_UPDATE_PROFILE_FULL "<TransitData id=\"1\" type=\"data\"><SourceID>db</SourceID><Content><Request class=\"profile\" function=\"updateProfile\"><Params/></Request></Content><TargetID>facebook</TargetID></TransitData>"
#define REQUEST_SET_SETTINGS "<Request class=\"settings\" function = \"setSettings\"><Params><string name=\"login\">email_vk@mail.ru</string><string name=\"password\">email_vk</string><string name=\"autoupdate\">10</string><string name=\"active\">1</string></Params></Request>"

#define JSON1 "[[86454,\"User 1\",\"http:\/\/cs02.vk470e7.jpg\",0],[30269836,\"User 2\",\"http:\/\/cs1894.facebook.ru\/u30269836\/b_360d6e12.jpg\",0],[39578937,\"Raven Varikset\",\"http:\/\/cs734.facebook.ru\/u39578937\/b_d0a2d693.jpg\",0],[39662875,\"Panda Fake\",\"http:\/\/cs765.facebook.ru\/u39662875\/b_254479b0.jpg\",0]]"

#define JSON2 "[[86454,\"name\",\"http:\",0],[123,\"name2\",\"http\",0],[39578937,\"Raa\"],[3965,\"Panda\",\"http\",0]]"

#define JSON_MESSAGE "{\"n\":146,\"d\":[[\"345\",\"1263195487\",[\"message_text\"],[9381442,\"Alexandr\tZaharov\",\"http:\/\/cs10358.userapi.com\/u9381442\/b_87e10f17.jpg\",\"c_550e9321\",2,0],[\"30269836\"],1],[\"343\",\"11263151345\",[\"message_text\"],[28752260,\"Dmitry\tPetrov\",\"http:\/\/cs9543.userapi.com\/u2875260\/b_941bc783.jpg\",\"c_d3969a3b\",2,1263553817],[\"30269836\"],1]],\"h\":296000002}"

#define JSON_MESSAGE_2 "{\"n\":146,\"d\":[\"sdfsdf\"],\"h\":296000002}"

#define JSON_MESSAGE_3 "{\"n\":146,\"d\":[[\"12\",\"342322\",[\"text\"],[9381442,\"Alexandr\tZaharov\",\"http:\/\/cs10358.userapi.com\/u9381442\/b_87e10f17.jpg\",\"c_550e9321\",2,0],[],1]],\"h\":296000002}"

#define JSON_PROFILE "{\"id\":30269836,\"fn\":\"Sergey\",\"ln\":\"Zaharov\",\"mn\":\"\",\"actv\":{0:\"30269836_151741570\",1:30269836,2:0,3:\"Сергей Захаров\",4:\"1250174917\",5:\"Segmentation fault (core dumped).\",\"ts\":427000002},\"ht\":{\"coi\":1,\"con\":\"ru\",\"cii\":112,\"cin\":\"Петрозаводск\"},\"sx\":2,\"bp\":\"http:\/\/cs9906.userapi.com\/u30269836\/a_2156884c.jpg\",\"bd\":19,\"bm\":7,\"by\":1989,\"fs\":5,\"pv\":1,\"fr\":{\"n\":61,\"d\":[]},\"mts\":296000002,\"us\":\"30269836\",\"ms\":1263558529.32,\"on\":0,\"isf\":0,\"isi\":0,\"f\":0,\"edu\":[[2089008,0,0,\"шк. № 2 им. А.С. Пушкина\",2006],[648,0,100,\"ПетрГУ\",2011],[466193,648,110,\"Математический\",2011]]}"
#define JSON_PROFILE_2 "{\"id\":30269836,\"fn\":\"Sergey\",\"ln\":\"Zaharov\"}"


GLOBAL_DECL();

CTF_TEST_DATA_FILE_NAME_DECL;
CTF_STAT_FILE_NAME_DECL;

/*
CTF_TEST_CASE(network_test) {
    CTF_TEST_NAME("http_get_test");
    char* header = NULL;
    char* body = NULL;
    int code = 0;
    code = http_get(CTF_TEST_DATA("URL_TEST"), CTF_TEST_DATA("PROXY"), atoi(CTF_TEST_DATA("PORT")), &header, &body);
    CTF_CHECK(header != NULL);
    CTF_CHECK(body != NULL);
    CTF_CHECK(code != 0);
}
*/

CTF_TEST_CASE(xml_request_test) {
     CTF_TEST_NAME("make_url_test1");
     char* url = NULL;
     xmlDocPtr reqXml;
     reqXml = xmlParseDoc(REQUEST_UPDATE_PROFILE);
     url = make_url(reqXml, CTF_TEST_DATA("MID"), CTF_TEST_DATA("SID"));
     CTF_CHECK(!strcmp(url, CTF_TEST_DATA("URL_PROFILE")));

     
     CTF_TEST_NAME("make_url_test2");
     url = NULL;
     url = make_url(NULL, CTF_TEST_DATA("MID"), CTF_TEST_DATA("SID"));
     CTF_CHECK(url == NULL);

     
    CTF_TEST_NAME("request_class_test1");
    char* class;
    char* function;
    reqXml = NULL;
    reqXml = xmlParseDoc(REQUEST_UPDATE_PROFILE);
    class = get_req_class(reqXml);
    function = get_req_function(reqXml);
    CTF_CHECK(!strcmp(class, CTF_TEST_DATA("CLASS_PROFILE")) );
    CTF_CHECK(!strcmp(function, CTF_TEST_DATA("FUNCTION_UPDATE_PROFILE")) );

    CTF_TEST_NAME("request_class_test2");
    reqXml = NULL;
    class = NULL;
    function = NULL;
    class = get_req_class(reqXml);
    function = get_req_function(reqXml);
    CTF_CHECK(class == NULL);
    CTF_CHECK(function == NULL);
    
}


CTF_TEST_CASE(init_test) {
    CTF_TEST_NAME("init_test");
    int res;

    struct ProfileData *cp = profile_create(DRIVER_ID);
    cp->login = CTF_TEST_DATA("LOGIN");
    cp->password = CTF_TEST_DATA("PASSWORD");

    res = initialization(cp);
    if(res == 0) {
        CTF_CHECK(cp->remixmid != NULL);
        CTF_CHECK(cp->remixsid != NULL);
    } else {
	CTF_CHECK(res == 1);

        CTF_CHECK(cp->remixmid == NULL);
        CTF_CHECK(cp->remixsid == NULL);
    }
}

/*
CTF_TEST_CASE(get_binary_data_test){
    CTF_TEST_NAME("get_binary_data_test");
    char* response = NULL;
    char* url = NULL;
    xmlDocPtr reqXml;

    reqXml = xmlParseDoc("<Request class=\"binaryData\" function=\"getBinaryData\"><Params><img name=\"Img\" uri=\"http://cs02.facebook.ru/u86454/b_f1470e7.jpg\"/></Params></Request>");

    url = make_url(reqXml, CTF_TEST_DATA("MID"), CTF_TEST_DATA("SID"));

    g_debug(url);
    CTF_CHECK(strcmp(url, "http://cs02.facebook.ru/u86454/b_f1470e7.jpg") == 0);
    http_get(url, "proxy.karelia.ru", 81, NULL, &response);
    CTF_CHECK(response != NULL);

}

CTF_TEST_CASE(settings_test) {
    CTF_TEST_NAME("set_settings_test");
    g_type_init();
    char* login;
    char* passw;
    char* mid;
    char* sid;
    int autoupdate = 0;
    int active = 0;
    xmlDocPtr reqXml, doc;
    GConfClient* client;
    xmlNodePtr rootNode, childNode, node;
    
    client = gconf_client_get_default ();
    reqXml = xmlParseDoc(REQUEST_SET_SETTINGS);
    set_settings (reqXml, doc, NULL);
    login = gconf_client_get_string (client, g_strconcat(PATH, LOGIN, NULL), NULL);
    passw = gconf_client_get_string (client, g_strconcat(PATH, PASSWORD, NULL), NULL);
    active = gconf_client_get_int (client, g_strconcat(PATH, STATUS, NULL), NULL);
    autoupdate = gconf_client_get_int (client, g_strconcat(PATH, AUTOUPDATE, NULL) , NULL);
		 
    CTF_CHECK(!strcmp(login, CTF_TEST_DATA("LOGIN")) );
    CTF_CHECK(!strcmp(passw, CTF_TEST_DATA("PASSWORD")) );
    CTF_CHECK(active == 1);
    CTF_CHECK(autoupdate == 10);

    mid = NULL;
    sid = NULL;
    mid = gconf_client_get_string (client, g_strconcat(PATH, REMIXMID, NULL), NULL);
    sid = gconf_client_get_string (client, g_strconcat(PATH, REMIXSID, NULL), NULL);

    CTF_CHECK(mid == NULL);
    CTF_CHECK(sid == NULL);
    
}
*/
CTF_TEST_CASE(check_json_test) {
    CTF_TEST_NAME("check_json_test");
    int status = 0;
    char* json;

    json = g_strdup(JSON1);
    status = check(json);
    CTF_CHECK(status == 0 );    
    
    status = check(CTF_TEST_DATA("JSON_1"));
    CTF_CHECK(status == 1 );

    status = check(CTF_TEST_DATA("JSON_2"));
    CTF_CHECK(status == 0)
    g_debug("status %d", status);
	    
    json = g_strdup(CTF_TEST_DATA("JSON_3"));
    status = check(json);
    CTF_CHECK(status == -2 );

    json = g_strdup(CTF_TEST_DATA("JSON_4"));
    status = check(json);
    CTF_CHECK(status == 0 );
}
/*
CTF_TEST_CASE(authorization_test) {
    CTF_TEST_NAME("authorization_test1");
    char* mid;
    int code = 0;
    GConfClient* client;

	
    g_type_init();
    client = gconf_client_get_default ();

    if (authorize(CTF_TEST_DATA("LOGIN"), CTF_TEST_DATA("PASSWORD")) == 0) {
        mid = gconf_client_get_string (client, g_strconcat(PATH, REMIXMID, NULL), NULL);
        CTF_CHECK(!strcmp(mid, CTF_TEST_DATA("MID")));
    }

    CTF_TEST_NAME("authorization_test2");
    code = authorize(CTF_TEST_DATA("LOGIN"), CTF_TEST_DATA("LOGIN"));
        CTF_CHECK(code == 1);
}


CTF_TEST_CASE(parser_test){
    CTF_TEST_NAME("parser_new_messages_test");
    g_debug("TEST = %d",TEST );
    char* json = NULL;
    int nm = 0;
    nm = parser_new_messages(CTF_TEST_DATA("JSON_NEW_MESSAGES")); 
    CTF_CHECK(nm == 21);   

    CTF_TEST_NAME("parser_friends_test");
    xmlNodePtr rootNode, node;
    xmlDocPtr doc;
    doc = xmlNewDoc(BAD_CAST g_strdup("1.0"));
    rootNode = xmlNewDocNode(doc, NULL,  "Response", NULL);
    xmlDocSetRootElement(doc, rootNode);

    xmlSetProp(rootNode, CLASS, "friends");
    xmlSetProp(rootNode, FUNCTION, "updateListFriends");

    node = xmlNewDocNode(doc, NULL,   PARAMS,  NULL);
    xmlAddChild(rootNode, node);

    nm = parser_friends(JSON1,doc);
    CTF_CHECK(nm == 4);
    nm = 0;

    nm = parser_friends(JSON2,doc);
    CTF_CHECK(nm == 2);
    nm = 0;
    xmlFreeDoc(doc);   

    CTF_TEST_NAME("parser_profile_test");
    doc = xmlNewDoc(BAD_CAST g_strdup("1.0"));
    rootNode = xmlNewDocNode(doc, NULL,  "Response", NULL);
    xmlDocSetRootElement(doc, rootNode);

    xmlSetProp(rootNode, CLASS, "profile");
    xmlSetProp(rootNode, FUNCTION, "updateProfile");

    node = xmlNewDocNode(doc, NULL, PARAMS,  NULL);
    xmlAddChild(rootNode, node);

    nm = parser_profile(doc,JSON_PROFILE, CTF_TEST_DATA("MID"));
    CTF_CHECK(nm == 0);
    nm = 0;

    nm = parser_profile(doc,JSON_PROFILE_2, CTF_TEST_DATA("MID"));
    CTF_CHECK(nm == 1);
    nm = 0;
    xmlFreeDoc(doc);
     
    CTF_TEST_NAME("parser_message_test");
    doc = xmlNewDoc(BAD_CAST g_strdup("1.0"));
    rootNode = xmlNewDocNode(doc, NULL,  "Response", NULL);
    xmlDocSetRootElement(doc, rootNode);

    xmlSetProp(rootNode, CLASS, "messages");
    xmlSetProp(rootNode, FUNCTION, "getInboxMessages");

    node = xmlNewDocNode(doc, NULL, PARAMS,  NULL);
    xmlAddChild(rootNode, node);

    nm = parser_messages(JSON_MESSAGE, doc);
    g_debug("nm = %d", nm);
    //Количество сообщений на 1 меньше чем в json объекте, 
    //т.к. последнее сообщение не должно разбирться парсером
    CTF_CHECK(nm == 1);
    nm = 0;

    nm = parser_messages(JSON_MESSAGE_2, doc);
    CTF_CHECK(nm == 0);
    nm = 0;

    nm = parser_messages(JSON_MESSAGE_3, doc);
    CTF_CHECK(nm == 0);
    nm = 0;
		
}

CTF_TEST_CASE(set_events_test){
    CTF_TEST_NAME("set_events_test");
     //g_type_init();
     msa_module_disp*  module;
     if (kernel_initialization() != 1) {
         module = malloc(sizeof(msa_module_disp));
         module->msa_mod = malloc(sizeof(msa_module));
         module->msa_mod->id = g_strdup_printf("facebook");
         module->msa_mod->type = DRIVER;
         module->msa_mod->set_events = handler_put_data;
         msa_module_init(module->msa_mod);
         g_debug("test");
         CTF_CHECK(init_event_manager(10) == 0);
     }
}
CTF_TEST_CASE(fb_driver_send_test){
    CTF_TEST_NAME("fb_driver_send_test");
     msa_module_disp*  module;
     xmlDocPtr response = NULL;
     xmlDocPtr reqXml = NULL;
     if (kernel_initialization() != 1) {
         module = malloc(sizeof(msa_module_disp));
         module->msa_mod = malloc(sizeof(msa_module));
         module->msa_mod->id = g_strdup_printf("facebook");
         module->msa_mod->type = DRIVER;
         module->msa_mod->set_events = handler_put_data;
         module->msa_mod->proxy = g_strdup_printf("proxy.karelia.ru");
         module->msa_mod->port = 81;
         msa_module_init(module->msa_mod);
	 
         reqXml = xmlParseDoc(REQUEST_UPDATE_PROFILE_FULL);
	 module->msa_mod->send(reqXml, &response, module->msa_mod);
	 xmlDocDump(stdout, response);
     }					     
										  
}
*/	

CTF_TEST_CASE(profile_test){
    CTF_TEST_NAME("profile_test");
    
    int num = atoi(CTF_TEST_DATA("NUM_PROFILES"));
    int i, j;
    
    gchar **cpnames = (gchar **)malloc(sizeof(gchar *) * num);
    struct ProfileData *cp;
    
    /* check work with empty profiles */
    j = 0;
    for (i = 0; i < num; i++)
    {
	cp = profile_create(DRIVER_ID);
	if (cp == NULL) {
	    j++;
	    break;
	}
	cpnames[i] = g_strdup(cp->id);
    }
    CTF_CHECK(j == 0);
    
    j = 0;
    for (i = 0; i < num; i+=2)
    {
	g_debug("check profile %s", cpnames[i]);
	cp = profile_get_by_id(cpnames[i]);
	if (cp == NULL) {
	    j++; 
	    break;
	}
    }
    CTF_CHECK(j == 0);
}

CTF_TEST_CASE(shutdown_test){
    CTF_TEST_NAME("module shutdown");
    
    error_type ret;
    struct ProfileData *cp;
    int num = atoi(CTF_TEST_DATA("NUM_PROFILES"));
    int i;
    
    struct msa_module **info = (struct msa_module **)malloc(sizeof(struct msa_module *) * num);
    
    int j = 0;
    for (i = 0; i < num; i++) {
	info[i] = (struct msa_module *)malloc(sizeof(struct msa_module));
	ret = msa_module_init(info[i]);
	g_debug("current profile: %s", info[i]->id);
	if (ret != SUCCESS)
	{
	    j++;
	    break;
	}
	cp = profile_get_by_id(info[i]->id);
	if (cp == NULL)
	{
	    g_debug("can't found %s", info[i]->id);
	    j++;
	    break;
	}
    }
    CTF_CHECK(j == 0);

    CTF_CHECK(profile_get_by_id("lalala") == NULL);
    CTF_CHECK(profile_get_by_id(info[(int)(num * 0.74)]->id) != NULL);
    
    j = 0;
    for (i = 0; i < num; i +=2) {
	ret = info[i]->shutdown(info[i]);
	if (ret != SUCCESS)
	{
	    j++;
	    break;
	}
	cp = profile_get_by_id(info[i]->id);
	if (cp != NULL)
	{
	    j++;
	    break;
	}
	
    }
    CTF_CHECK(j == 0);

    j = 0;
    for (i = 1; i < num; i +=2) {
	ret = info[i]->shutdown(info[i]);
	if (ret != SUCCESS)
	{
	    
	    j++;
	    break;
	}
	cp = profile_get_by_id(info[i]->id);
	if (cp != NULL)
	{
	    j++;
	    break;
	}
	
    }
    CTF_CHECK(j == 0);
}
