<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:php="http://php.net/xsl"> 
<xsl:output method="text"
	version="1.1" 
	standalone="yes" 
	indent="no" 
	omit-xml-declaration="yes" /> 

<xsl:template match="/">
	<xsl:apply-templates select="formats" mode="formats.struct" />
	<xsl:apply-templates select="formats" mode="formats.ext" />
</xsl:template>

<xsl:template match="formats" mode="formats.ext">
const gchar *dicto_extensions[]={
	<xsl:for-each select="format">"<xsl:value-of select="@ext" />", </xsl:for-each>NULL
};
</xsl:template>

<xsl:template match="formats" mode="formats.struct">
/* 
 * Autogenerated file from dicto-formats.xml, using dicto-formats.xslt
 * Do not edit directly.
 */
const DictoFormat dicto_formats[FORMAT_LAST+1]={
<xsl:apply-templates select="format"/>
{
.id=FORMAT_LAST,
.channels=0,
.rate=0,
.bits=0,
.mime=NULL,
.desc=NULL,
.ext=NULL,
.encoder=NULL,
.muxer=NULL,
}
};
</xsl:template> 

<xsl:template match="formats/format">
{
.id=FORMAT_<xsl:value-of select="@id"/>,
.desc="<xsl:value-of select="@name"/>",
.ext="<xsl:value-of select="@ext"/>",
<xsl:apply-templates select="caps|filter|muxer|encoder"/>
},
</xsl:template> 

<xsl:template match="formats/format/caps">
.channels=<xsl:value-of select="@channels"/>,
.rate=<xsl:value-of select="@rate"/>,
.bits=<xsl:value-of select="@bits"/>,
.mime="<xsl:value-of select="@mime"/>",
</xsl:template>

<xsl:template match="formats/format/filter">
.filter="<xsl:value-of select="."/>",
</xsl:template>

<xsl:template match="formats/format/muxer">
.muxer="<xsl:value-of select="."/>",
</xsl:template>

<xsl:template match="formats/format/encoder">
.encoder="<xsl:value-of select="."/>",
</xsl:template>

</xsl:stylesheet>
