#ifndef NMEAGEOLOGGINGFORMATTER_H
#define NMEAGEOLOGGINGFORMATTER_H

#include "AbstractGeoLoggingFormatter.h"

QTM_USE_NAMESPACE

class NMEASentence
{
public:
    explicit     NMEASentence   (const QString &command);

    void         addParameter   (const QString &parameter);

    QByteArray   format         () const;
    QString      toString       () const;

protected:
    char checksum (const QByteArray &sentence) const;

    QString         m_Command;
    QList<QString>  m_Parameters;
};

class NMEAGeoLoggingFormatterPrivate;

class NMEAGeoLoggingFormatter : public AbstractGeoLoggingFormatter
{
    Q_OBJECT

public:
    explicit NMEAGeoLoggingFormatter(QObject *parent = 0);
            ~NMEAGeoLoggingFormatter();

    QString  id             () const;
    QString  friendlyName   () const;

protected slots:
    void     onPositionUpdate   (const QGeoPositionInfo &position);

    void     onSatellitesInUse  (const QList<QGeoSatelliteInfo> &satellites);
    void     onSatellitesInView (const QList<QGeoSatelliteInfo> &satellites);

protected:
    QString  datestamp  (const QDateTime &datetime) const;
    QString  timestamp  (const QDateTime &datetime) const;
    QString  latlon     (double latitude, double longitude) const;

    NMEASentence*        GPGGA  (const QGeoPositionInfo &posinfo) const;
    NMEASentence*        GPGLL  (const QGeoPositionInfo &posinfo) const;
    NMEASentence*        GPGSA  (const QList<QGeoSatelliteInfo> &sats, const QGeoPositionInfo &posinfo) const;
    QList<NMEASentence*> GPGSV  (const QList<QGeoSatelliteInfo> &sats, const QGeoPositionInfo &posinfo) const;
    NMEASentence*        GPRMC  (const QGeoPositionInfo &posinfo) const;
    NMEASentence*        GPVTG  (const QGeoPositionInfo &posinfo) const;
    NMEASentence*        GPZDA  (const QGeoPositionInfo &posinfo) const;

    NMEAGeoLoggingFormatterPrivate *d;
};

#endif // NMEAGEOLOGGINGFORMATTER_H
