#include "LoggingServicePerformer.h"

#include <QDebug>

class LoggingServicePerformerPrivate
{
public:
    QIODevice *io;
};

LoggingServicePerformer::LoggingServicePerformer(QIODevice *io, QObject *parent)
    : AbstractLoggingPerformer(parent)
{
    this->d = new LoggingServicePerformerPrivate;
    d->io = io;
}

LoggingServicePerformer::~LoggingServicePerformer()
{
    delete this->d;
}

void LoggingServicePerformer::onDataReady(const QByteArray &data)
{
    d->io->write(data);
}
