#include "FileLogger.h"

#include <QDebug>

#include <QDir>
#include <QFile>
#include <QDate>

#define MAX_LOGFILE_SIZE_BYTES (1024 * 1024 * 5)

class FileLoggerPrivate
{
public:
    QString logdir;
    QString filename;

    QFile *file;
    quint64 bytesOut;
};

FileLogger::FileLogger(const QString &logdir, const QString &filename, QObject *parent)
    : AbstractLoggingPerformer(parent)
{
    qDebug() << "FileLogger: ctor()";
    this->d = new FileLoggerPrivate;
    d->logdir = logdir;
    d->filename = filename;
    d->bytesOut = 0;
    d->file = NULL;
}

FileLogger::~FileLogger()
{
    qDebug() << "FileLogger: dtor()";

    if(d->file != NULL)
    {
        d->file->close();
    }

    delete this->d;
}

void FileLogger::onDataReady(const QByteArray &data)
{
    if(d->file == NULL)
    {
        int i = 1;
        QString filepath = QDir(d->logdir).absoluteFilePath(QDate::currentDate().toString(d->filename + "-%1.log").arg(i));

        while(QFileInfo(filepath).size() > MAX_LOGFILE_SIZE_BYTES)
        {
            filepath = QDir(d->logdir).absoluteFilePath(QDate::currentDate().toString(d->filename + "-%1.log").arg(i));
            i++;
        }

        qDebug() << "FileLogger: Using logfile:" << filepath;

        d->file = new QFile(filepath, this);
        d->file->open(QFile::Append | QFile::WriteOnly);
    }

    d->bytesOut += d->file->write(data);
    d->file->flush();

    if(d->bytesOut >= MAX_LOGFILE_SIZE_BYTES)
    {
        d->file->close();
        delete d->file;
        d->file = NULL;
        d->bytesOut = 0;
    }
}
