#include "LoggingServicePerformerFactory.h"

#include <QDebug>

class LoggingServicePerformerFactoryPrivate
{
public:
    LoggingManager *manager;
    AbstractGeoLoggingFormatter *formatter;
};

LoggingServicePerformerFactory::LoggingServicePerformerFactory(AbstractGeoLoggingFormatter *formatter, LoggingManager *manager, QObject *parent)
    : QObject(parent)
{
    this->d = new LoggingServicePerformerFactoryPrivate;
    d->manager = manager;
    d->formatter = formatter;
}

LoggingServicePerformer* LoggingServicePerformerFactory::createInstance(QIODevice *io, QObject *parent)
{
    qDebug() << "ServicePerformerFactory - Creating instance.";
    LoggingServicePerformer *result = new LoggingServicePerformer(io, parent);
    qDebug() << "ServicePerformerFactory - Registering instance with logging manager.";
    d->manager->addLogger(d->formatter, result);
    return result;
}

void LoggingServicePerformerFactory::destroyInstance(LoggingServicePerformer *performer)
{
    qDebug() << "ServicePerformerFactory: destroyInstance() - Unregistering with logging manager.";
    d->manager->removeLogger(performer);
    delete performer;
}
