#ifndef LOGGINGMANAGER_H
#define LOGGINGMANAGER_H

#include <QHash>
#include <QObject>

#include "AbstractLoggingPerformer.h"
#include "AbstractGeoLoggingFormatter.h"

class ColumbusController;
class LoggingManagerPrivate;

class LoggingManager : public QObject
{
    Q_OBJECT

public:
    explicit LoggingManager(QObject *parent = 0);
            ~LoggingManager();

    QHash<QString,AbstractGeoLoggingFormatter*> formatters() const;
    QHash<AbstractLoggingPerformer*,AbstractGeoLoggingFormatter*> loggers() const;

public slots:
    void     initialize     (ColumbusController *controller);
    void     setupLogging   ();

    void     addDataFormat  (AbstractGeoLoggingFormatter *formatter);

    void     addLogger      (AbstractGeoLoggingFormatter *formatter, AbstractLoggingPerformer *logger);
    void     removeLogger   (AbstractLoggingPerformer *logger);

private:
    LoggingManagerPrivate *d;
};

#endif // LOGGINGMANAGER_H
