#ifndef PLUGINMANAGER_H
#define PLUGINMANAGER_H

#include <QHash>
#include <QObject>

#include "ColumbusPluginInterface.h"

class ColumbusController;
class PluginManagerPrivate;

class PluginManager : public QObject
{
    Q_OBJECT

public:
    explicit PluginManager  (QObject *parent = 0);
            ~PluginManager  ();

    void     initialize     (ColumbusController *controller);
    void     loadPlugins    ();

    ColumbusController*           controller () const;
    QHash<QString,ColumbusPluginInterface*>   plugins    () const;

protected:
    bool registerPlugin     (ColumbusPluginInterface *plugin);
    void unregisterPlugin   (const QString &pluginId);

private:
    PluginManagerPrivate *d;
};

#endif // PLUGINMANAGER_H
