#ifndef SENSORREADER_H
#define SENSORREADER_H

#include <QPair>

class SensorReader {

public:
    // return the lux value from the sensors, or -1 on error.
    static int getLux();

    // return whether or not Scratchbox has been detected, to enable testing on desktop.
    static bool detectSB();

    // convert lux values to EV (Exposure Values).
    // return value is a pair consisting of the integral part, and number of one thirds of a stop
    // so for example EV 5 2/3 is returned as (5,2)
    // EV is calculated according to ISO 100 speed.
    static QPair<int,int> Lux2EV(int);
};


#endif // SENSORREADER_H
