#include "sensorreader.h"
#include "types.h"
#include <math.h>


#include <QtDebug>
#include <QFile>




int SensorReader::getLux()
{
    // scratchbox detected, supply fake value    
    if(SensorReader::detectSB()) {
        static int fakeLux = 0;

        int retval = fakeLux;
        fakeLux++;
        if(fakeLux > 65000) {
            fakeLux = 0;
        }
        return retval;
    }
    // assume real RX-48/RX-51 HW, read LUX file from the sysfs
    else {
        QFile sysFile("/sys/class/i2c-adapter/i2c-2/2-0029/lux");
        if (!sysFile.open(QIODevice::ReadOnly | QIODevice::Text)) {
            return -1;
        }
        QTextStream in(&sysFile);
        QString lux = in.readLine();

        return lux.toInt(0, 10);

    } // real lux file

}


bool SensorReader::detectSB()
{
    static bool sbDetectedAlready = false;
    static bool isSB = false;

    if(sbDetectedAlready) {
        return isSB;
    }

    sbDetectedAlready = true;
    QFile sb("/scratchbox");

    if(sb.exists()) {
        qDebug() << "/scratchbox exists, using fake values";
        isSB = true;
        return true;
    }
    else {
        // scratchbox does not exist, using real values from sensor
        isSB = false;
        return false;
    }
}



QPair<int,int> SensorReader::Lux2EV(int lux)
{

// avoid negative EV value    
    if(lux < 2 ) lux = 2;

    qreal ev = log2((qreal)lux/2.5);

    int q = (int) ev;
    qreal rem_tmp = ev-q;
    int r = 0;
    if (rem_tmp >= 0.00 && rem_tmp < 0.16666666666) {
        r = 0;
    }
    else if (rem_tmp >= 0.16666666666 && rem_tmp < 0.5) {
        r = 1;
    }
    else if (rem_tmp >= 0.5 && rem_tmp < 0.8333333333333) {
        r = 2;
    }
    else if (rem_tmp >= 0.833333333333 && rem_tmp < 1) {
        r = 0;
        q++;  // round up to next integral number
    }

    return QPair<int,int>(q,r);

}

