#ifndef LUXWIDGET_H
#define LUXWIDGET_H

#include <QWidget>
#include <QPixmap>



#include "types.h"

class QPaintEvent;
class QResizeEvent;
namespace QtMobility {
    class QSystemDisplayInfo;
}



class LuxWidget : public QWidget
{
    Q_OBJECT
public:
    LuxWidget();

protected:
    virtual void paintEvent(QPaintEvent *e);
    virtual void resizeEvent(QResizeEvent *e);
    virtual void timerEvent(QTimerEvent *event);
    virtual void mouseReleaseEvent(QMouseEvent *);

private:
    QPixmap       cache;
    bool          dirty;
    QtMobility::QSystemDisplayInfo *displayinfo;

    int timerId;
    LuxusUnits currentUnit;

};

#endif
