#include "inputnumberwindow.h"
#include "ui_inputnumberwindow.h"

InputNumberWindow::InputNumberWindow(QWidget *parent, QString title, int min, int max) :
    QDialog(parent),
    ui(new Ui::InputNumberWindow)
{
    ui->setupUi(this);

    if (!title.isEmpty())
        ui->lblTitle->setText(title);
    ui->txtValue->setInputMask("000000");
    m_Value = min;
    m_MinValue = min;
    m_MaxValue = max;
    ui->txtValue->setText(QString::number(m_Value));

    connect(ui->txtValue, SIGNAL(textChanged(QString)), this, SLOT(ValueChangedSlot(QString)));
    connect(ui->pbnMinus, SIGNAL(clicked()), this, SLOT(MinusSlot()));
    connect(ui->pbnPlus, SIGNAL(clicked()), this, SLOT(PlusSlot()));
    connect(ui->pbnOk, SIGNAL(clicked()), this, SLOT(OkSlot()));

}

InputNumberWindow::~InputNumberWindow()
{
    delete ui;
}

void InputNumberWindow::MinusSlot()
{
    if (m_Value > m_MinValue){
        m_Value--;
        ui->txtValue->setText(QString::number(m_Value));
    }
}

void InputNumberWindow::PlusSlot()
{
    if (m_Value < m_MaxValue){
        m_Value++;
        ui->txtValue->setText(QString::number(m_Value));
    }
}

void InputNumberWindow::OkSlot()
{
    accept();
}

int InputNumberWindow::GetValue()
{
    return m_Value;
}

void InputNumberWindow::ValueChangedSlot(QString value)
{
    int newValue = value.toInt();
    if (newValue >= m_MinValue && newValue <= m_MaxValue)
        m_Value = newValue;
    else{
        ui->txtValue->setText(QString::number(m_Value));
    }
}
