#include "chooseitemwindow.h"
#include "ui_chooseitemwindow.h"
#include <QLabel>
#include <QPushButton>
#include <QCloseEvent>

ChooseItemWindow::ChooseItemWindow(QWidget *parent, Player* player, int mode) :
    QDialog(parent),
    ui(new Ui::ChooseItemWindow)
{
    ui->setupUi(this);
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5AutoOrientation);
#endif

    m_Close = false;
    m_Selected = NULL;
    m_Player = player;
    m_Mode = mode;
    ShowItems();
}

ChooseItemWindow::~ChooseItemWindow()
{
    delete ui;
}

void ChooseItemWindow::ShowItems()
{
    switch (m_Mode)
    {
    case ChooseMeal:
        ShowMeals();
        break;
    case ChooseItem:
        ShowBackpackItems();
        break;
    case ChooseSpecialItem:
        ShowSpecialItems();
        break;
    case ChooseWeapon:
        ShowWeapons();
        break;
    default:
        break;
    }
}

void ChooseItemWindow::ShowMeals()
{
    setWindowTitle("Choose a Meal to eat");
    int row=0;
    int index = 0;
    QSizePolicy stretchZero;
    stretchZero.setHorizontalStretch(0);

    foreach(Item* i, m_Player->Items){
        if (!i->GetIsSpecial() && i->GetIsMeal()){
            QLabel* lbl = new QLabel(this);
            lbl->setSizePolicy(stretchZero);
            lbl->setText(QString("<b>%1:</b>").arg(row + 1));
            ui->layItems->addWidget(lbl, row, 0);

            lbl = new QLabel(this);
            lbl->setText(i->Name);
            lbl->setWordWrap(true);
            ui->layItems->addWidget(lbl, row, 1);

            lbl = new QLabel(this);
            lbl->setText(i->Description);
            lbl->setWordWrap(true);
            ui->layItems->addWidget(lbl, row, 2);

            QPushButton* pbn = new QPushButton(this);
            connect(pbn, SIGNAL(clicked()), this, SLOT(SelectedSlot()));
            pbn->setObjectName(QString::number(index));
            pbn->setText("Eat");
            pbn->setMaximumSize(75, 50);
            ui->layItems->addWidget(pbn, row, 3);

            row++;
        }
        index++;
    }
}

void ChooseItemWindow::ShowBackpackItems()
{
    setWindowTitle("Choose an Item");
    int row=0;
    int index = 0;
    QSizePolicy stretchZero;
    stretchZero.setHorizontalStretch(0);

    foreach(Item* i, m_Player->Items){
        if (!i->GetIsSpecial()){
            QLabel* lbl = new QLabel(this);
            lbl->setSizePolicy(stretchZero);
            lbl->setText(QString("<b>%1:</b>").arg(row + 1));
            ui->layItems->addWidget(lbl, row, 0);

            lbl = new QLabel(this);
            lbl->setText(i->Name);
            lbl->setWordWrap(true);
            ui->layItems->addWidget(lbl, row, 1);

            lbl = new QLabel(this);
            lbl->setText(i->Description);
            lbl->setWordWrap(true);
            ui->layItems->addWidget(lbl, row, 2);

            QPushButton* pbn = new QPushButton(this);
            connect(pbn, SIGNAL(clicked()), this, SLOT(SelectedSlot()));
            pbn->setObjectName(QString::number(index));
            pbn->setText("Select");
            pbn->setMaximumSize(75, 50);
            ui->layItems->addWidget(pbn, row, 3);

            row++;
        }
        index++;
    }
}

void ChooseItemWindow::ShowSpecialItems()
{
    setWindowTitle("Choose an Item");
    int row=0;
    int index = 0;
    QSizePolicy stretchZero;
    stretchZero.setHorizontalStretch(0);

    foreach(Item* i, m_Player->Items){
        if (i->GetIsSpecial()){
            QLabel* lbl = new QLabel(this);
            lbl->setSizePolicy(stretchZero);
            lbl->setText(QString("<b>%1:</b>").arg(row + 1));
            ui->layItems->addWidget(lbl, row, 0);

            lbl = new QLabel(this);
            lbl->setText(i->Name);
            lbl->setWordWrap(true);
            ui->layItems->addWidget(lbl, row, 1);

            lbl = new QLabel(this);
            lbl->setText(i->Description);
            lbl->setWordWrap(true);
            ui->layItems->addWidget(lbl, row, 2);

            QPushButton* pbn = new QPushButton(this);
            connect(pbn, SIGNAL(clicked()), this, SLOT(SelectedSlot()));
            pbn->setObjectName(QString::number(index));
            pbn->setText("Select");
            pbn->setMaximumSize(75, 50);
            ui->layItems->addWidget(pbn, row, 3);

            row++;
        }
        index++;
    }
}

void ChooseItemWindow::ShowWeapons()
{
    setWindowTitle("Choose a Weapon");
    int row=0;
    int index = 0;
    QSizePolicy stretchZero;
    stretchZero.setHorizontalStretch(0);

    foreach(Weapon* w, m_Player->Weapons()){
        QLabel* lbl = new QLabel(this);
        lbl->setSizePolicy(stretchZero);
        lbl->setText(QString("<b>%1:</b>").arg(row + 1));
        ui->layItems->addWidget(lbl, row, 0);

        lbl = new QLabel(this);
        lbl->setText(w->Name);
        lbl->setWordWrap(true);
        ui->layItems->addWidget(lbl, row, 1);

        lbl = new QLabel(this);
        lbl->setText(w->Description);
        lbl->setWordWrap(true);
        ui->layItems->addWidget(lbl, row, 2);

        QPushButton* pbn = new QPushButton(this);
        connect(pbn, SIGNAL(clicked()), this, SLOT(SelectedSlot()));
        pbn->setObjectName(QString::number(index));
        pbn->setText("Select");
        pbn->setMaximumSize(75, 50);
        ui->layItems->addWidget(pbn, row, 3);

        row++;
        index++;
    }
}

void ChooseItemWindow::SelectedSlot()
{
    int idx = ((QWidget*)sender())->objectName().toInt();

    switch (m_Mode)
    {
    case ChooseMeal:
    case ChooseItem:
    case ChooseSpecialItem:
        m_Selected = m_Player->Items.at(idx);
        break;
    case ChooseWeapon:
        m_Selected = m_Player->Weapons().at(idx);
        break;
    default:
        break;
    }

    m_Close = true;
    accept();
}


void ChooseItemWindow::closeEvent(QCloseEvent* event)
{
    if (m_Close)
        event->accept();
    else
        event->ignore();
}
