#include "selectfromlistwindow.h"
#include "ui_selectfromlistwindow.h"

SelectFromListWindow::SelectFromListWindow(QWidget *parent, QString title,
                                           QString message, QStringList elements,
                                           int number) :
    DialogWindow(parent),
    ui(new Ui::SelectFromListWindow)
{
    ui->setupUi(this);
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5AutoOrientation);
    setAttribute(Qt::WA_Maemo5StackedWindow);
#endif

    setWindowTitle(title);
    ui->lblMessage->setText(message);

    m_Selected = 0;
    m_Elements = elements;
    m_Number = number;
    ui->pbnDone->setEnabled(false);

    connect(ui->pbnDone, SIGNAL(clicked()), SLOT(accept()));
    ShowData();
}

SelectFromListWindow::~SelectFromListWindow()
{
    delete ui;
}

void SelectFromListWindow::ShowData()
{
    int row = 0;
    foreach (QString element, m_Elements){
        QLabel* lbl = new QLabel(this);
        lbl->setText(element);
        ui->layElements->addWidget(lbl, row, 0);

        QCheckBox* chk = new QCheckBox(this);
        chk->setObjectName(element);
        connect(chk, SIGNAL(clicked(bool)), this, SLOT(SelectSlot(bool)));
        ui->layElements->addWidget(chk, row, 1, Qt::AlignRight);
        m_CheckButtons.append(chk);

        row++;
    }
}

void SelectFromListWindow::SelectSlot(bool selected)
{
    if (selected)
        m_Selected++;
    else
        m_Selected--;


    foreach (QCheckBox* c, m_CheckButtons)
        c->setEnabled(m_Selected < m_Number || c->isChecked());
    ui->pbnDone->setEnabled(m_Selected == m_Number);
}

QStringList SelectFromListWindow::GetSelected()
{
    QStringList res;

    foreach (QCheckBox* c, m_CheckButtons){
        if (c->isChecked())
            res.append(c->objectName());
    }

    return res;
}
