#ifndef CARTWHEELWINDOW_H
#define CARTWHEELWINDOW_H

#include <QMainWindow>
#include <QEventLoop>
#include "core/player.h"
#include "randomnumberpicker.h"

namespace Ui {
    class CartwheelWindow;
}

class CartwheelWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit CartwheelWindow(QWidget *parent = 0, Player* player=0);
    ~CartwheelWindow();

    void exec();

protected:
    void closeEvent(QCloseEvent *event);

private:
    Ui::CartwheelWindow *ui;

    bool m_CanClose;
    int m_Bet;
    int m_Value;
    int m_Won;
    Player* m_Player;
    QEventLoop* m_Loop;

    RandomNumberPicker* m_RandomPicker;

    void EnableButtons(bool enable);
    void UpdateData();
    void Evaluate(int random);

private slots:
    void RandomSlot(int);
    void BetMinusSlot();
    void BetPlusSlot();
    void MinusSlot();
    void PlusSlot();
    void PlaySlot();

};

#endif // CARTWHEELWINDOW_H
