#ifndef TUBEAPI_H
#define TUBEAPI_H

#include <QObject>
#include <QStringList>
#include <QUrl>

class QNetworkReply;

class TubeApi : public QObject
{
    Q_OBJECT

public:
    TubeApi( QObject *parent );
    virtual ~TubeApi();

    QStringList results() const;

signals:
    void finished( bool success );

public slots:
    void search( const QString &searchTube );

private slots:
    void finished( QNetworkReply *reply );

private:
    bool processApiResult( QIODevice *source );

    struct TubeApiPrivate *d;
};

#endif // TUBEAPI_H
