#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QtGui/QMainWindow>
#include <QStringList>

class TubeApi;
class QWidget;
class QBoxLayout;
class QVBoxLayout;
class QPushButton;

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    MainWindow(QWidget *parent = 0);
    ~MainWindow();

public slots:
    void go(const QString&);
    void goCircle();
    void goDistrict();
    void goCentral();
    void goVictoria();
    void goHammersmithCity();
    void goJubilee();
    void goBakerloo();
    void goNorthern();
    void goWaterlooCity();
    void goPiccadilly();
    void goMetropolitan();
    void goAll();

private slots:
    void finished(bool);

private:
    TubeApi *tubeapi;

    QMainWindow *mainWindow;
    QMainWindow *dataWindow;
    QWidget *tubeListWidget;
    QBoxLayout *mainlayout;
    QVBoxLayout *sublayout1;
    QVBoxLayout *sublayout2;
    QPushButton *circle;
    QPushButton *district;
    QPushButton *central;
    QPushButton *victoria;
    QPushButton *hmcity;
    QPushButton *jubilee;
    QPushButton *bakerloo;
    QPushButton *northern;
    QPushButton *waterloocity;
    QPushButton *piccadilly;
    QPushButton *metropolitan;
    QPushButton *all;

};

#endif // MAINWINDOW_H
