#include <QLabel>
#include <QPushButton>
#include <QVBoxLayout>
#include <QBoxLayout>
#include <QTextEdit>
#include <QtGui/QMaemo5Style>

#include "mainwindow.h"
#include "tubeapi.h"

MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent)
{
	setAttribute(Qt::WA_Maemo5StackedWindow);

	dataWindow = new QMainWindow ( this );
	dataWindow->setAttribute(Qt::WA_Maemo5StackedWindow);

	tubeListWidget = new QWidget( this );
	mainlayout = new QBoxLayout( QBoxLayout::LeftToRight );	
	sublayout1 = new QVBoxLayout;	
	sublayout2 = new QVBoxLayout;	
	
	circle = new QPushButton ( "CIRCLE", this );
	circle->setStyleSheet("QPushButton { color: yellow; font: bold 28px; }");
	district = new QPushButton ( "DISTRICT", this );
	district->setStyleSheet("QPushButton { color: green ;font: bold 28px;}");
	central = new QPushButton ( "CENTRAL", this );
	central->setStyleSheet("QPushButton { color: red ;font: bold 28px;}");
	northern = new QPushButton ( "NORTHERN", this );
	northern->setStyleSheet("QPushButton { color: black; font: bold 28px; }");
	piccadilly = new QPushButton ( "PICCADILLY", this );
	piccadilly->setStyleSheet("QPushButton { color: darkBlue; font: bold 28px; }");
	hmcity = new QPushButton ( "HAMMERSMITHCITY", this );
	hmcity->setStyleSheet("QPushButton { color: magenta; font: bold 28px; }");
	jubilee = new QPushButton ( "JUBILEE", this );
	jubilee->setStyleSheet("QPushButton { color: darkGrey; font: bold 28px; }");
	metropolitan = new QPushButton ( "METROPOLITAN", this );
	metropolitan->setStyleSheet("QPushButton { color: darkMagenta; font: bold 28px; }");
	bakerloo = new QPushButton ( "BAKERLOO", this );
	bakerloo->setStyleSheet("QPushButton { color: darkred; font: bold 28px; }");
	waterloocity = new QPushButton ( "WATERLOOCITY", this );
	waterloocity->setStyleSheet("QPushButton { color: cyan; font: bold 28px; }");
	victoria = new QPushButton ( "VICTORIA", this );
	victoria->setStyleSheet("QPushButton { color: blue; font: bold 28px; }");
	all = new QPushButton ( "ALL", this );
	all->setStyleSheet("QPushButton { color: white; font: bold 28px; }");

	sublayout1->addWidget( circle );
	sublayout1->addWidget( district );
	sublayout1->addWidget( central );
	sublayout1->addWidget( northern );
	sublayout1->addWidget( piccadilly );
	sublayout1->addWidget( hmcity );
	sublayout2->addWidget( jubilee );
	sublayout2->addWidget( metropolitan );
	sublayout2->addWidget( victoria );
	sublayout2->addWidget( waterloocity );
	sublayout2->addWidget( bakerloo );
	sublayout2->addWidget( all );

	mainlayout->addLayout(sublayout1);
	mainlayout->addLayout(sublayout2);

	tubeListWidget->setLayout(mainlayout);

	setCentralWidget(tubeListWidget);

	connect( all, SIGNAL(clicked()), SLOT(goAll()) );
	connect( circle, SIGNAL(clicked()), SLOT(goCircle()) );
	connect( victoria, SIGNAL(clicked()), SLOT(goVictoria()) );
	connect( jubilee, SIGNAL(clicked()), SLOT(goJubilee()) );
	connect( bakerloo, SIGNAL(clicked()), SLOT(goBakerloo()) );
	connect( hmcity, SIGNAL(clicked()), SLOT(goHammersmithCity()) );
	connect( metropolitan, SIGNAL(clicked()), SLOT(goMetropolitan()) );
	connect( piccadilly, SIGNAL(clicked()), SLOT(goPiccadilly()) );
	connect( waterloocity, SIGNAL(clicked()), SLOT(goWaterlooCity()) );
	connect( northern, SIGNAL(clicked()), SLOT(goNorthern()) );
	connect( district, SIGNAL(clicked()), SLOT(goDistrict()) );
	connect( central, SIGNAL(clicked()), SLOT(goCentral()) );

	tubeapi = new TubeApi( this );

	connect( tubeapi, SIGNAL(finished(bool)), SLOT(finished(bool)) );
}


MainWindow::~MainWindow()
{
}

void MainWindow::goAll()
{
	go("all"); 
}

void MainWindow::goCircle()
{
	go("circle"); 
}

void MainWindow::goDistrict()
{
	go("district"); 
}

void MainWindow::goCentral()
{
	go("central"); 
}

void MainWindow::goPiccadilly()
{
	go("piccadilly"); 
}

void MainWindow::goVictoria()
{
	go("victoria"); 
}

void MainWindow::goBakerloo()
{
	go("bakerloo"); 
}

void MainWindow::goJubilee()
{
	go("jubilee"); 
}

void MainWindow::goNorthern()
{
	go("northern"); 
}

void MainWindow::goWaterlooCity()
{
	go("waterloocity"); 
}

void MainWindow::goMetropolitan()
{
	go("metropolitan"); 
}

void MainWindow::goHammersmithCity()
{
	go("hammersmithcity"); 
}

void MainWindow::go(const QString& tubeline)
{
    tubeapi->search(tubeline); 
    dataWindow->show();
}

void MainWindow::finished( bool ok )
{
	QWidget *dataWidget = new QWidget ( this );
	QVBoxLayout *dataLayout = new QVBoxLayout();
	int count = 0;
	QString line1;
	QTextEdit *tubedata = new QTextEdit ( this );	
	QTextEdit *txtContent = new  QTextEdit( this );	
	tubedata->setReadOnly(true);
	txtContent->setReadOnly(true);
	txtContent->ensureCursorVisible();
	txtContent->setStyleSheet("QTextEdit { background-color: lightGrey ;}");
	dataLayout->addWidget(tubedata);
	foreach(QString s, tubeapi->results())
	{
		count++;

		if ( (count % 2) == 1 )
		{
			tubedata->append(s);
		}
		else if ( (count % 2) == 0 && tubeapi->results().size() < 3)
		{
			txtContent->append(s);
			dataLayout->addWidget(txtContent);
		}
	}
	dataWidget->setLayout(dataLayout);
	dataWindow->setCentralWidget(dataWidget);
}
