#include <glib.h>
#include <dbus/dbus-glib.h>
#include <dbus/dbus.h>
#include <dbus/dbus-glib-lowlevel.h>

#include <QApplication>
#include <QWidget>

#include <phonon/phononnamespace.h>
#include <phonon/audiooutput.h>
#include <phonon/seekslider.h>
#include <phonon/mediaobject.h>
#include <phonon/volumeslider.h>
#include <phonon/backendcapabilities.h>

#include <iostream>
#include <fstream>


static DBusHandlerResult signal_filter(DBusConnection *connection, DBusMessage *message, void *user_data);

static Phonon::MediaObject* musicOn; 
static Phonon::MediaObject* musicOff; 
static int lockCount=0;
static int active=1;

static void connectToDbusVibra();

int main(int argc, char *argv[])
{
		      
	QApplication app(argc, argv);
	app.setApplicationName("lockdaemon");

	musicOn =Phonon::createPlayer(Phonon::MusicCategory,Phonon::MediaSource("/home/opt/lockdaemon/open.mp3"));
	musicOff =Phonon::createPlayer(Phonon::MusicCategory,Phonon::MediaSource("/home/opt/lockdaemon/close.mp3"));
	
	QWidget::connect(musicOn,SIGNAL(finished()),musicOn,SLOT(stop()));
	QWidget::connect(musicOff,SIGNAL(finished()),musicOff,SLOT(stop()));
	
	GMainLoop *loop;
	DBusConnection *bus;
	DBusError error;

	loop = g_main_loop_new (NULL, FALSE);
	dbus_error_init (&error);
	bus = dbus_bus_get (DBUS_BUS_SYSTEM, &error);

	connectToDbusVibra();
	
	if (!bus) 
	{
		g_warning ("Failed to connect to the D-BUS daemon: %s", error.message);							
		dbus_error_free (&error);												
		return 1;											                                       
	}
	
	dbus_connection_setup_with_g_main (bus, NULL);

	dbus_bus_add_match (bus, "type='signal',interface='com.nokia.mce.signal'",&error);

	dbus_bus_add_match (bus, "type='signal',interface='hopbeat.lockDaemon'",&error);
	
	dbus_bus_add_match (bus, "type='signal',interface='org.freedesktop.Hal.Device'",&error);

	dbus_connection_add_filter (bus, signal_filter, loop, NULL);											
	g_main_loop_run (loop);												      

return 0;
}
	


static int connectedVib;
static DBusMessage* msgVib;
static DBusMessageIter argsVib;
static DBusConnection* connVib;
static DBusError errVib;
static DBusPendingCall* pendingVib;
static int retVib;
static const char* paramVib;
															


static void connectToDbusVibra()
{

       	dbus_error_init(&errVib);
      	connVib = dbus_bus_get_private(DBUS_BUS_SYSTEM, &errVib);
	if (dbus_error_is_set(&errVib))
	{
		dbus_error_free(&errVib);
	}
	if (NULL == connVib)
	{
		return;
	}
	
	retVib = dbus_bus_request_name(connVib, "lockdaemon.vibra", DBUS_NAME_FLAG_REPLACE_EXISTING , &errVib);

	if (dbus_error_is_set(&errVib))
	{
		dbus_error_free(&errVib);
	}
	if (DBUS_REQUEST_NAME_REPLY_PRIMARY_OWNER != retVib)
	{
		return;
	}
	connectedVib=1;
							 

}



static void vibrate(int type)
{
 
	std::cout<<"vibrating"<<std::endl;

        if (type==0) //change this to enum
        {
                paramVib = "PatternTouchscreen";
        }
        else if (type==1)
        {
                paramVib = "PatternPowerKeyPress";
        }
        else if (type==2)
        {
                paramVib= "PatternKeyboard";
        }

        if (connectedVib==0)
        {
                connectToDbusVibra();
                if (connectedVib==0)
                        return;
        }

        msgVib = dbus_message_new_method_call("com.nokia.mce",                                  
			"/com/nokia/mce/request",
			"com.nokia.mce.request",
			"req_vibrator_pattern_activate");

   if (NULL == msgVib)
        {
                return;
        }


   dbus_message_iter_init_append(msgVib, &argsVib);
   if (!dbus_message_iter_append_basic(&argsVib, DBUS_TYPE_STRING, &paramVib))
   {
                return;
   }

        if (!dbus_connection_send_with_reply (connVib, msgVib, &pendingVib, -1))
        {
                return;
        }
        if (NULL == pendingVib)
        {
                return;
        }

        dbus_connection_flush(connVib);
        dbus_message_unref(msgVib);





}









static int readKeyboardState()
{
	
	std::string line;
	std::ifstream myfile ("/sys/devices/platform/gpio-switch/slide/state");
	
    	if (myfile.is_open())
  	{
	//	while (! myfile.eof() )
		{
			getline (myfile,line);
		}
		myfile.close();
	}

		
  	else std::cout << "Unable to open file"; 

	std::cout << line << std::endl;

	if (line.compare("open")==0)
		return 1;
	else
		return 0;


}


static DBusHandlerResult signal_filter (DBusConnection *connection, DBusMessage *message, void *user_data)
{
          

	GMainLoop *loop = (GMainLoop*)user_data;

	if (dbus_message_is_signal (message, "org.freedesktop.Hal.Device","Condition"))
	{

		std::string path = "/org/freedesktop/Hal/devices/platform_slide";
		
	  	
		DBusError error;
  		char *s;
		char* s2;
		dbus_error_init (&error);
		if (dbus_message_get_args(message, &error, DBUS_TYPE_STRING, &s, DBUS_TYPE_STRING, &s2, DBUS_TYPE_INVALID) && active) 
		{
			
			if (path.compare(dbus_message_get_path(message))==0)
			{
						std::cout<<"KEYBOARD"<<std::endl;
						if (readKeyboardState())
						{
							musicOff->stop();
							musicOn->play();
							std::cout << "open"<<std::endl;
						}
						else
						{
							musicOn->stop();
							musicOff->play();
							std::cout << "closed" <<std::endl;
						}
			}
		}
		return DBUS_HANDLER_RESULT_HANDLED;
	}
     
	if (dbus_message_is_signal (message, "org.freedesktop.Local", "Disconnected")) 
	{
		g_main_loop_quit (loop);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
         
	//Lock message
	else if (dbus_message_is_signal (message, "com.nokia.mce.signal", "tklock_mode_ind")) 
	{
	  	DBusError error;
  		char *s;
		dbus_error_init (&error);
		if (dbus_message_get_args(message, &error, DBUS_TYPE_STRING, &s, DBUS_TYPE_INVALID) && active) 
		{
			if (s[0]=='l' && lockCount==0)
			{
			//	musicOn->stop();
			//	musicOff->play();
				vibrate(2);
				lockCount=1;
				std::cout<<"keyboard locked"<<std::endl;
			}
			else if (s[0]=='u')
			{
			//	musicOff->stop();
			//	musicOn->play();
				vibrate(2);
				lockCount=0;
				std::cout<<"keyboard unlocked"<<std::endl;
			}
		}
		return DBUS_HANDLER_RESULT_HANDLED;
	}

	//Silence message	
	else if (dbus_message_is_signal (message, "hopbeat.lockDaemon", "Switch")) 
	{
	  	DBusError error;
  		char *s;
		dbus_error_init (&error);
		if (dbus_message_get_args(message, &error, DBUS_TYPE_STRING, &s, DBUS_TYPE_INVALID)) 
		{
			if (active==0)
				active=1;
			else
				active=0;
		}
		else 
		{
			g_print("Ping received, but error getting message: %s\n", error.message);
			dbus_error_free (&error);
		}
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	
	
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}

