/* vim: set sw=4 ts=4 et: */
/*
 * This file is part of Live Wallpaper (livewp)
 * 
 * Copyright (C) 2010 Vlad Vasiliev
 * Copyright (C) 2010 Tanya Makova
 *       for the code
 * 
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 * 
 * This software is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
*/
/*******************************************************************************/
#include "livewp-settings.h"
/*******************************************************************************/
void lw_about(void){

    GtkWidget *window = NULL,
    *vbox = NULL,
    *label_about = NULL;
    window = gtk_dialog_new();
    gtk_window_set_title(GTK_WINDOW(window), _("About"));
    gtk_window_set_position(GTK_WINDOW(window), GTK_WIN_POS_CENTER);
    gtk_window_set_modal(GTK_WINDOW(window), TRUE);
    vbox = gtk_vbox_new (FALSE, 5);
    label_about = gtk_label_new (_("Live Wallpaper Version 0.8.1 \n Copyright(c) 2010\n \
Tanya Makova\n Vlad Vasiliev\n \
Copyright(c) 2010 for design themes Berlin, Modern and Accel Vasya Bobrikov\n \
Copyright(c) 2010 for design theme Matrix and icons Andrew Zhilin\n \
Translators:\n \
Finnish - Marko Vertainen\n \
Spain  - Alejandro López\n \
Russian - Tanya Makova \n \
          Vlad Vasiliev\n")); 
    gtk_box_pack_start (GTK_BOX (vbox), label_about, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(window)->vbox),
                                   vbox, TRUE, TRUE, 0);
    gtk_widget_show (label_about);
    gtk_widget_show (vbox);
    gtk_widget_show (window);
    gtk_dialog_run(GTK_DIALOG(window));

}
/*******************************************************************************/
GtkWidget *
create_category_selector (Animation_WallpaperPrivate *priv){
    GtkWidget *selector;
    GSList *store = priv->extheme_list;
    GList *category_list;
    GHashTable *result_table = NULL;

    result_table = g_hash_table_new(g_str_hash, g_str_equal);
    while (store){  
        if (!g_hash_table_lookup(result_table, g_hash_table_lookup(store->data, "category")))
            g_hash_table_insert(result_table, g_hash_table_lookup(store->data, "category"), (gint *)1);     
        store = g_slist_next(store);
    }
    
    /* Add Xscreensaver for install message */
    if (!g_hash_table_lookup(result_table,"Xscreensaver"))
            g_hash_table_insert(result_table, "Xscreensaver", (gint *)1);
   

    category_list = g_hash_table_get_keys (result_table);
    selector = hildon_touch_selector_new_text();

    hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (selector), "LiveWallpaper" );
    while (category_list){  
        hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (selector),category_list->data );
        category_list = g_list_next(category_list);
    }

    return selector;
}

/*******************************************************************************/
void
theme_button_clicked(GtkWidget *button, GdkEventButton *event, Animation_WallpaperPrivate *priv){
    lw_theme_settings(GTK_WIDGET(button), priv);
}
/********************************************************************************/
void
set_button_image(GtkWidget * button, Animation_WallpaperPrivate *priv, gboolean enable){
    GtkWidget * image = NULL; 
    GdkPixbuf * pixbuf = NULL;
    gchar *str = NULL;
    gchar *icon_on = NULL;
    gchar *icon_off = NULL;
    GSList *store = priv->extheme_list;

    while (store){
        if (!strcmp(priv->theme, g_hash_table_lookup(store->data, "name"))){
            icon_on = g_strdup(g_hash_table_lookup(store->data, "icon_on"));
            icon_off = g_strdup(g_hash_table_lookup(store->data, "icon_off"));
            break;
        }
        store = (GSList *)g_list_next(store);
    }
    if (enable){
        if (icon_on)
            str = g_strdup_printf("%s", icon_on);
        else 
            str = g_strdup_printf( "%s/%s/%s", THEME_PATH, 
                            priv->theme, "icon.png");
            if (access(str, F_OK) != 0){
                g_free(str);
                str = g_strdup_printf( "%s/%s/%s", THEME_PATH, 
                            "Video", "icon.png");
            }

    }else {
        if (icon_off)
            str = g_strdup_printf("%s", icon_off);
        else 
            str = g_strdup_printf( "%s/%s/%s", THEME_PATH, 
                            priv->theme, "icond.png");
            if (access(str, F_OK) != 0){
                g_free(str);
                str = g_strdup_printf( "%s/%s/%s", THEME_PATH, 
                            "Video", "icond.png");
            }
    }
    pixbuf = gdk_pixbuf_new_from_file_at_size (str, 
                                                 124, 
                                                 79, 
                                                 NULL);
    if (str)
        g_free(str);
    if (icon_on)
        g_free(icon_on);
    if (icon_off)
        g_free(icon_off);
    if (pixbuf){
        image = gtk_image_new_from_pixbuf (pixbuf);
        g_object_unref(G_OBJECT(pixbuf));
    }

    //hildon_button_set_image (HILDON_BUTTON (button), image);
    GList *list = gtk_container_get_children(GTK_CONTAINER (button));
    if (list){
        gtk_container_remove(GTK_CONTAINER (button), list->data);
    }
    gtk_container_add(GTK_CONTAINER (button), image);
    gtk_widget_show(image);
    gtk_widget_show(button);

}
/********************************************************************************/
GtkWidget *
create_image_button (gint view, DBusConnection *conn_sess){
    GtkWidget *button;
    GtkWidget *event_box;

    Animation_WallpaperPrivate *priv = g_new0(Animation_WallpaperPrivate, 1);
    /* Add external themes to priv */
    priv->extheme_list = get_list_exthemes();

    priv->view = view;
    priv->theme_string_parametr1 = NULL;
    priv->dbus_conn_session = conn_sess;
    read_config(priv);

    event_box = gtk_event_box_new();
    g_object_set_data(G_OBJECT(event_box), "view", GINT_TO_POINTER(view));
    g_object_set_data(G_OBJECT(event_box), "priv", priv);
    set_button_image(event_box, priv, check_applet_state(view));
    g_signal_connect(G_OBJECT (event_box), "button_press_event", G_CALLBACK(theme_button_clicked), priv);
    return event_box;
#if 0
    button = hildon_button_new(HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT,
                                    HILDON_BUTTON_ARRANGEMENT_VERTICAL);
    g_object_set_data(G_OBJECT(button), "view", GINT_TO_POINTER(view));
    g_object_set_data(G_OBJECT(button), "priv", priv);
    set_button_image(button, priv, check_applet_state(view));
    g_signal_connect(button, "clicked", G_CALLBACK(theme_button_clicked), priv);
    hildon_button_set_image_position (HILDON_BUTTON (button), GTK_POS_RIGHT);
    return button;
#endif
}
/********************************************************************************/
void
changed_value_theme_cb (HildonPickerButton *picker, Animation_WallpaperPrivate *priv)
{
    const gchar *choice = hildon_button_get_value(HILDON_BUTTON (picker));
    GtkWidget *vbox = NULL;
    GtkWidget *area_vbox = NULL;
        
    area_vbox = g_object_get_data(G_OBJECT(priv->window), "area_vbox");
    if (!area_vbox)
        return;
    vbox = g_object_get_data(G_OBJECT(priv->window), "custom_vbox");
    if (vbox){
        gtk_widget_destroy(vbox);
    }
    vbox = gtk_vbox_new (TRUE, 5);
    g_object_set_data(G_OBJECT(priv->window), "custom_vbox", vbox);
    gtk_box_pack_start(GTK_BOX(area_vbox),
                                   vbox, FALSE, FALSE, 5);
    if (choice) {
        if (!strcmp(choice, _("Berlin"))){
            rich_animation_additional_parametr(vbox,priv);
        }
        if (!strcmp(choice, _("Modern"))){
            rich_animation_additional_parametr(vbox,priv);
        }
        if (!strcmp(choice, _("Matrix"))){
            rich_animation_additional_parametr(vbox,priv);
        }

        if (!strcmp(choice, _("Accel"))){
            rich_animation_additional_parametr(vbox,priv);
        }
        if (!strcmp(choice, _("Video"))){
            additional_parametr_for_theme_video(vbox, priv);
        }
    }
    gtk_widget_show(vbox);
}
/********************************************************************************/
void
changed_value_category_cb (HildonPickerButton *picker, Animation_WallpaperPrivate *priv)
{
    GtkWidget *theme_button = NULL;
    const gchar *choice = hildon_button_get_value(HILDON_BUTTON (picker));

    theme_button = g_object_get_data(G_OBJECT(priv->window), "theme_button");
    if (!theme_button) 
        return;
    HildonTouchSelector * selector =  hildon_picker_button_get_selector((HildonPickerButton *) theme_button);
    hildon_touch_selector_remove_column(selector, 0); 
    hildon_touch_selector_append_text_column(selector, (GtkTreeModel*)gtk_list_store_new (1, G_TYPE_STRING), TRUE);
    fill_theme_button(priv, theme_button, (gchar *)hildon_button_get_value(HILDON_BUTTON (picker)));
    /* check xscreensaver category */
    if (choice){
        if (!strcmp(choice,"Xscreensaver"))
            if (access("/usr/bin/xscreensaver", F_OK) != 0){
                hildon_banner_show_information(GTK_WIDGET(picker), NULL, 
                _("You haven't got the installed package Xscreensaver. Please install it via using Application Manager"));
            }

    }
}
/********************************************************************************/
void
fill_theme_button (Animation_WallpaperPrivate *priv, GtkWidget *button, gchar *category){

    gchar *theme = priv->theme;
    gboolean flag = False;
    gint num=0;
        hildon_button_set_value(HILDON_BUTTON (button), NULL);
    if (!category){
        changed_value_theme_cb(HILDON_PICKER_BUTTON (button), priv);
        return;
    }
    GSList *store = priv->extheme_list;
    HildonTouchSelector * selector =  hildon_picker_button_get_selector((HildonPickerButton *) button);
    if (!selector)
        selector = (HildonTouchSelector *)hildon_touch_selector_new_text ();
    
    hildon_button_set_value(HILDON_BUTTON(button), NULL);
    if (!strcmp(category, "LiveWallpaper")){
        hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (selector), _("Berlin"));
        hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (selector), _("Modern"));
        hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (selector), _("Matrix"));
        hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (selector), _("Accel"));
        hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (selector), _("Video"));
        num = 5;        
        if (theme){ 
            if (!strcmp(theme, "Berlin")){
                hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (selector), 0, 0);
                hildon_button_set_value(HILDON_BUTTON(button), _("Berlin"));
            }
            if (!strcmp(theme, "Modern")){
                hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (selector), 0, 1);
                hildon_button_set_value(HILDON_BUTTON(button), _("Modern"));
            }
            if (!strcmp(theme, "Matrix")){
                hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (selector), 0, 2);
                hildon_button_set_value(HILDON_BUTTON(button), _("Matrix"));
            }
            if (!strcmp(theme, "Accel")){
                hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (selector), 0, 3);
                hildon_button_set_value(HILDON_BUTTON(button), _("Accel"));
            }
            if (!strcmp(theme, "Video")){
                hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (selector), 0, 4);
                hildon_button_set_value(HILDON_BUTTON(button), _("Video"));
            }
       }
    }
    while (store){  
        if (!g_hash_table_lookup(store->data, "category"))
            continue;
        if (!strcmp(g_hash_table_lookup(store->data, "category"), category)){
            hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (selector), g_hash_table_lookup(store->data, "name"));
            if (!strcmp(theme, g_hash_table_lookup(store->data, "name"))){
                hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (selector), 0, num);
                hildon_button_set_value(HILDON_BUTTON(button), _(g_hash_table_lookup(store->data, "name")));
            }
            num++;
        }
        store = g_slist_next(store);
    }
    /* Added Shreman's Aquarium for message */
    if (!strcmp(category, "Unknown")){
        store = priv->extheme_list;
        while (store){  
            if (!strcmp("Sherman's Aquarium" , g_hash_table_lookup(store->data, "name"))){
                flag = TRUE;
                break;
            }
            store = g_slist_next(store);
        }
        if (!flag)
            hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (selector), "Sherman's Aquarium");
    }

        hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (button),
                                                       HILDON_TOUCH_SELECTOR (selector));

    changed_value_theme_cb(HILDON_PICKER_BUTTON (button), priv);
}
/********************************************************************************/
GtkWidget *
create_themes_button (Animation_WallpaperPrivate *priv, gchar *category){

    GtkWidget *button;
    button = hildon_picker_button_new (HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);
    hildon_button_set_title (HILDON_BUTTON (button), _("Theme"));

   
    return button;
}
/********************************************************************************/
GtkWidget *
create_categories_button (Animation_WallpaperPrivate *priv){

    GtkWidget *button;
    GtkWidget *selector;
    gchar *theme = priv->theme;
    gint num=0;
    GHashTable *result_table = NULL;

    result_table = g_hash_table_new(g_str_hash, g_str_equal);
    selector = create_category_selector(priv);
    button = hildon_picker_button_new (HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);
    hildon_button_set_title (HILDON_BUTTON (button), _("Category"));
    hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (button),
                                                       HILDON_TOUCH_SELECTOR (selector));
    if (theme) {
        if (!strcmp(theme, "Berlin")){
            hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (selector), 0, 0); 
            hildon_button_set_value(HILDON_BUTTON(button), "LiveWallpaper");
        }
        if (!strcmp(theme, "Modern")){
            hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (selector), 0, 0); 
            hildon_button_set_value(HILDON_BUTTON(button), "LiveWallpaper");
        }
        if (!strcmp(theme, "Matrix")){
            hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (selector), 0, 0); 
            hildon_button_set_value(HILDON_BUTTON(button), "LiveWallpaper");
        }
        if (!strcmp(theme, "Accel")){
            hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (selector), 0, 0); 
            hildon_button_set_value(HILDON_BUTTON(button), "LiveWallpaper");
        }
        if (!strcmp(theme, "Video")){
            hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (selector), 0, 0); 
            hildon_button_set_value(HILDON_BUTTON(button), "LiveWallpaper");
        }
        GSList *store = priv->extheme_list;
        num = 1;
        while (store){
            if (g_hash_table_lookup(result_table, g_hash_table_lookup(store->data, "category")) == NULL){
                g_hash_table_insert(result_table, g_hash_table_lookup(store->data, "category"), (gint *)num);     
                num++;
            }
            if (!strcmp(theme, g_hash_table_lookup(store->data, "name"))){
                if (g_hash_table_lookup(store->data, "category"))
                    hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR (selector), 0, 
                    (gint)g_hash_table_lookup(result_table, g_hash_table_lookup(store->data, "category"))); 
                    hildon_button_set_value(HILDON_BUTTON(button), g_hash_table_lookup(store->data, "category"));
                break;
            }

            store = g_slist_next(store);
        }
    }
    return button;
}

/*******************************************************************************/
GtkWidget *
create_bool_button (gboolean active, gchar *name)
{
    GtkWidget *button;
    button = hildon_check_button_new (HILDON_SIZE_AUTO);
    gtk_button_set_label (GTK_BUTTON (button), name);
    hildon_check_button_set_active(HILDON_CHECK_BUTTON(button), active);
    return button;
}
/*******************************************************************************/
GtkWidget *
create_enable_button (gboolean active)
{
    GtkWidget *button;
    button = hildon_check_button_new (HILDON_SIZE_FINGER_HEIGHT);
    gtk_button_set_label (GTK_BUTTON (button), _("Enable"));
    hildon_check_button_set_active(HILDON_CHECK_BUTTON(button), active);
    return button;
}

/*******************************************************************************/
void
show_settings(GtkWidget *widget, Animation_WallpaperPrivate *priv){
    lw_main_settings(priv, NULL);
}
/*******************************************************************************/
void 
lw_main_settings(Animation_WallpaperPrivate *priv, gpointer data){
    gint result;
    GtkWidget *window = NULL;
    GtkWidget *theme_button1;
    GtkWidget *theme_button2;
    GtkWidget *theme_button3;
    GtkWidget *theme_button4;
    GtkWidget *hbox;
    Animation_WallpaperPrivate *priv_temp = NULL;

    window = gtk_dialog_new();

    gtk_window_set_title(GTK_WINDOW(window), _("Live Wallpaper Settings"));
    gtk_window_set_position(GTK_WINDOW(window), GTK_WIN_POS_CENTER);
    gtk_window_set_modal(GTK_WINDOW(window), TRUE);
    /* Create Theme button */
    hbox = gtk_hbox_new(FALSE, 0);
    theme_button1 = create_image_button(1, priv->dbus_conn_session);
    gtk_box_pack_start(GTK_BOX(hbox),
                                   theme_button1, TRUE, TRUE, 0);
    theme_button2 = create_image_button(2, priv->dbus_conn_session);
    gtk_box_pack_start(GTK_BOX(hbox),
                                   theme_button2, TRUE, TRUE, 0);
    theme_button3 = create_image_button(3, priv->dbus_conn_session);
    gtk_box_pack_start(GTK_BOX(hbox),
                                   theme_button3, TRUE, TRUE, 0);
    theme_button4 = create_image_button(4, priv->dbus_conn_session);
    gtk_box_pack_start(GTK_BOX(hbox),
                                   theme_button4, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(window)->vbox),
                                   hbox, TRUE, TRUE, 5);

    gtk_widget_show (theme_button1);
    gtk_widget_show (theme_button2);
    gtk_widget_show (theme_button3);
    gtk_widget_show (theme_button4);
    gtk_widget_show_all (hbox);
    gtk_widget_show (window);
    gtk_dialog_add_button(GTK_DIALOG(window), _("About"), GTK_RESPONSE_NO);

    result = gtk_dialog_run(GTK_DIALOG(window));

    priv_temp = g_object_get_data(G_OBJECT(theme_button1), "priv");
    if (priv_temp){
        g_free(priv_temp);
        priv_temp =NULL;
    }
    priv_temp = g_object_get_data(G_OBJECT(theme_button2), "priv");
    if (priv_temp){
        g_free(priv_temp);
        priv_temp =NULL;
    }
    priv_temp = g_object_get_data(G_OBJECT(theme_button3), "priv");
    if (priv_temp){
        g_free(priv_temp);
        priv_temp =NULL;
    }
    priv_temp = g_object_get_data(G_OBJECT(theme_button4), "priv");
    if (priv_temp){
        g_free(priv_temp);
        priv_temp =NULL;
    }


    switch(result){
        case GTK_RESPONSE_NO:
            gtk_widget_destroy(window);
            window = NULL;
            lw_about();
        break;
    }


    if (window)
        gtk_widget_destroy(window);
}
/*******************************************************************************/
void
file_button_clicked(GtkButton *button, Animation_WallpaperPrivate *priv){

    GtkWidget *dialog = hildon_file_chooser_dialog_new(GTK_WINDOW (priv->window), GTK_FILE_CHOOSER_ACTION_OPEN);

    if (priv->theme_string_parametr1)
        gtk_file_chooser_set_filename(GTK_FILE_CHOOSER(dialog), priv->theme_string_parametr1);

    gtk_widget_show_all (GTK_WIDGET (dialog));

    if (gtk_dialog_run(GTK_DIALOG(dialog)) == GTK_RESPONSE_OK)
    {
      hildon_button_set_value (HILDON_BUTTON(button), gtk_file_chooser_get_filename(GTK_FILE_CHOOSER(dialog)));
    }
    gtk_widget_destroy (dialog);

}
/*******************************************************************************/
void
rich_animation_additional_parametr(GtkWidget *vbox, Animation_WallpaperPrivate *priv){
    GtkWidget *rich_animation_button;

    /* Create rich animation button */  
    rich_animation_button = create_bool_button(priv->rich_animation, _("Rich Animation"));
    gtk_box_pack_start(GTK_BOX(vbox),
                                   rich_animation_button, TRUE, TRUE, 5);
    g_object_set_data(G_OBJECT(priv->window), "rich_animation_button", rich_animation_button);
    gtk_widget_show (rich_animation_button);
}
/*******************************************************************************/
void
additional_parametr_for_theme_video(GtkWidget *vbox, Animation_WallpaperPrivate *priv){

    GtkWidget *file_button;
    GtkWidget *sound_button;
    GtkWidget *rich_animation_button;

    if (priv->theme_string_parametr1)
        file_button = hildon_button_new_with_text (HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL,
                                                   _("Play file"), priv->theme_string_parametr1);
    else
        file_button = hildon_button_new_with_text (HILDON_SIZE_FINGER_HEIGHT,HILDON_BUTTON_ARRANGEMENT_VERTICAL,
                                                   _("Play file")," ");

    g_signal_connect (file_button, "clicked", G_CALLBACK (file_button_clicked), priv);

    gtk_box_pack_start(GTK_BOX(vbox),
                                   file_button, TRUE, TRUE, 5);
    g_object_set_data(G_OBJECT(priv->window), "filename_button", file_button);    
    /* Create rich animation button */  
    rich_animation_button = create_bool_button(priv->rich_animation, _("Loop"));
    gtk_box_pack_start(GTK_BOX(vbox),
                                   rich_animation_button, TRUE, TRUE, 5);
    g_object_set_data(G_OBJECT(priv->window), "rich_animation_button", rich_animation_button);
    /* Create sound button */  
    sound_button = create_bool_button(priv->theme_bool_parametr1, _("Sound"));
    gtk_box_pack_start(GTK_BOX(vbox),
                                   sound_button, TRUE, TRUE, 5);
    g_object_set_data(G_OBJECT(priv->window), "sound_button", sound_button);

    gtk_widget_show (file_button);
    gtk_widget_show (sound_button);
    gtk_widget_show (rich_animation_button);

}
/*******************************************************************************/
void 
lw_theme_settings(GtkWidget *button, Animation_WallpaperPrivate *priv) {
    gint result;
    GtkWidget *window = NULL;
    GtkWidget *scrolled_window = NULL;
    GtkWidget *save_button;
    GtkWidget *theme_button;
    GtkWidget *category_button;
    GtkWidget *enable_button;
    GtkWidget *vbox;
    GtkWidget *temp_button;
    GtkWidget *area_vbox;
    GtkWidget *button1 = NULL;
    GtkWidget *rich_animation_button = NULL;
    gint view = priv->view;

    window = gtk_dialog_new();
    priv->window = window;

    gtk_window_set_title(GTK_WINDOW(window), _("View Settings"));
    gtk_window_set_position(GTK_WINDOW(window), GTK_WIN_POS_CENTER);
    gtk_window_set_modal(GTK_WINDOW(window), TRUE);

    /* Create panarea */
    area_vbox = gtk_vbox_new(FALSE, 2);
    g_object_set_data(G_OBJECT(window), "area_vbox", area_vbox);
    scrolled_window = hildon_pannable_area_new ();
    hildon_pannable_area_add_with_viewport(HILDON_PANNABLE_AREA (scrolled_window), GTK_WIDGET (area_vbox));
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(window)->vbox),
                                   scrolled_window, FALSE, FALSE, 0);

    gtk_widget_set_size_request(scrolled_window, -1, 370);

    /* Create Enable button */
    enable_button = create_enable_button(check_applet_state(view)); 
    gtk_box_pack_start(GTK_BOX(area_vbox),
                                   enable_button, FALSE, FALSE, 5);
    /* Create Category button */
    category_button = create_categories_button(priv);
    g_object_set_data(G_OBJECT(window), "category_button", category_button);
    g_signal_connect (G_OBJECT (category_button), "value-changed",  G_CALLBACK (changed_value_category_cb), priv);
    gtk_box_pack_start(GTK_BOX(area_vbox),
                                   category_button, FALSE, FALSE, 5);
    /* Create Custom vbox */
    vbox = gtk_vbox_new (FALSE, 5);
    g_object_set_data(G_OBJECT(window), "custom_vbox", vbox);

    /* Create Theme button */
    theme_button = create_themes_button(priv, (gchar *)hildon_button_get_value(HILDON_BUTTON (category_button)));
    g_object_set_data(G_OBJECT(window), "theme_button", theme_button);
    g_signal_connect (G_OBJECT (theme_button), "value-changed",  G_CALLBACK (changed_value_theme_cb), priv);
    gtk_box_pack_start(GTK_BOX(area_vbox),
                                   theme_button, FALSE, FALSE, 5);
    fill_theme_button(priv, theme_button, (gchar *)hildon_button_get_value(HILDON_BUTTON (category_button)));

    /* Pack custom vbox. It must be last widget */
    gtk_box_pack_start(GTK_BOX(area_vbox),
                                   vbox, FALSE, FALSE, 5);

    gtk_widget_show (enable_button);
    gtk_widget_show (category_button);
    gtk_widget_show (theme_button);
    gtk_widget_show (vbox);
    gtk_widget_show (area_vbox);
    gtk_widget_show (scrolled_window);
    gtk_widget_show (window);

    save_button = gtk_dialog_add_button(GTK_DIALOG(window), _("Save"), GTK_RESPONSE_YES);

    result = gtk_dialog_run(GTK_DIALOG(window));

    switch(result){
        case GTK_RESPONSE_YES:
            /* Check theme */
            if (hildon_button_get_value(HILDON_BUTTON (theme_button)) &&
                strcmp(hildon_button_get_value(HILDON_BUTTON (theme_button)), "")){
                /* Check Xsnow program */
                if (!strcmp(hildon_button_get_value(HILDON_BUTTON (theme_button)), _("Xsnow"))){
                    if (access("/usr/bin/xsnow", F_OK) != 0){
                        hildon_banner_show_information(GTK_WIDGET(button), NULL, 
                        _("You haven't got the installed package Xsnow. Please install it via using Application Manager"));
                        /* if not scuccess exit from wthout saving */ 
                        break;
                    }
                }
                /* Check Xsnow program */
                if (!strcmp(hildon_button_get_value(HILDON_BUTTON (theme_button)), "Sherman's Aquarium")){
                    if (access("/usr/bin/shermans", F_OK) != 0){
                        hildon_banner_show_information(GTK_WIDGET(button), NULL, 
                        _("You haven't got the installed package 'Sherman's Aquarium'. Please install it via using Application Manager"));
                        /* if not scuccess exit from wthout saving */ 
                        break;
                    }
                }

                if (priv->theme)
                    g_free(priv->theme);
                if (!strcmp(hildon_button_get_value(HILDON_BUTTON (theme_button)), _("Berlin")))
                    priv->theme = g_strdup("Berlin");
                if (!strcmp(hildon_button_get_value(HILDON_BUTTON (theme_button)), _("Modern")))
                    priv->theme = g_strdup("Modern");
                if (!strcmp(hildon_button_get_value(HILDON_BUTTON (theme_button)), _("Matrix")))
                    priv->theme = g_strdup("Matrix");
                if (!strcmp(hildon_button_get_value(HILDON_BUTTON (theme_button)), _("Accel")))
                    priv->theme = g_strdup("Accel");
                if (!strcmp(hildon_button_get_value(HILDON_BUTTON (theme_button)), _("Video"))){
                    priv->theme = g_strdup("Video");
                    button1 = g_object_get_data(G_OBJECT(priv->window), "filename_button");
                    if (button1){
                        if (priv->theme_string_parametr1)
                            g_free(priv->theme_string_parametr1);
                        priv->theme_string_parametr1 = g_strdup((gchar*)hildon_button_get_value (HILDON_BUTTON(button1)));
                    }
                    temp_button = g_object_get_data(G_OBJECT(priv->window), "sound_button");
                    if (temp_button){
                        /* Check rich animation */
                        if (hildon_check_button_get_active (HILDON_CHECK_BUTTON(temp_button)))
                            priv->theme_bool_parametr1 = TRUE;
                        else
                            priv->theme_bool_parametr1 = FALSE;
                    }
                }
                /* Check external themes */
                GSList *store = priv->extheme_list;
                while (store){
                    if (!strcmp(hildon_button_get_value(HILDON_BUTTON (theme_button)), _(g_hash_table_lookup(store->data, "name")))){
                        priv->theme = g_strdup(g_hash_table_lookup(store->data, "name"));
                        //priv->hash_theme = store->data;
                        break;
                    }
                    store = g_slist_next(store);
                }

            }

            rich_animation_button = g_object_get_data(G_OBJECT(priv->window), "rich_animation_button");
            if (rich_animation_button){
                /* Check rich animation */
                if (hildon_check_button_get_active (HILDON_CHECK_BUTTON(rich_animation_button)))
                    priv->rich_animation = TRUE;
                else
                    priv->rich_animation = FALSE;
            }
            /* Save config */
            save_config(priv);
            /* action with applet */
            if (hildon_check_button_get_active (HILDON_CHECK_BUTTON(enable_button))){
                    if (!check_applet_state(view)){
                        start_applet(view);
                    }else {
                        send_dbus_signal (priv,
                              LIVEWP_SIGNAL_INTERFACE,
                              LIVEWP_SIGNAL_PATH,
                              LIVEWP_RELOAD_CONFIG);
                    }
            }else
                    if (check_applet_state(view))
                        stop_applet(view);

            set_button_image(button, priv, check_applet_state(view));
            break;
        default:
        case GTK_RESPONSE_OK:
        break;
        case GTK_RESPONSE_NO:
            gtk_widget_destroy(window);
            window = NULL;
            lw_about();
        break;
    }
    if (window)
        gtk_widget_destroy(window);
}
/*******************************************************************************/
gboolean
check_applet_state(gint number){

    HDConfigFile *config_file = NULL;
    GKeyFile *gkey_file = NULL;
    gchar *str = NULL;
    gboolean result = FALSE;
    if (number > 4 || number < 1)
        return FALSE;

    str = g_strdup_printf("livewp-home-widget.desktop-%i", (number - 1));
    config_file = hd_config_file_new(NULL, "/home/user/.config/hildon-desktop/", "home.plugins");
    
    gkey_file = hd_config_file_load_file(config_file, FALSE);
    if (gkey_file && str){
        result = g_key_file_has_group(gkey_file, str);
        g_free(str);
    }
    return result;
}
/*******************************************************************************/
void
start_applet(gint number){

    HDConfigFile *config_file = NULL;
    GKeyFile *gkey_file = NULL;
    gchar *str = NULL;

    if (number > 4 || number < 1)
        return;
    str = g_strdup_printf("livewp-home-widget.desktop-%i",(number - 1));
    config_file = hd_config_file_new(NULL, "/home/user/.config/hildon-desktop/", "home.plugins");
    
    gkey_file = hd_config_file_load_file(config_file, FALSE);
    if (gkey_file){
        g_key_file_set_string (gkey_file, str, "X-Desktop-File", "/usr/share/applications/hildon-home/livewp-home-widget.desktop");
        hd_config_file_save_file( config_file, gkey_file);
        g_key_file_free(gkey_file);
    }else
        fprintf(stderr, "Problem with config file");
    if (str)
        g_free(str);
    g_object_unref(config_file);
}
/*******************************************************************************/
void
stop_applet(gint number){
    HDConfigFile *config_file = NULL;
    GKeyFile *gkey_file = NULL;
    gchar *str = NULL;

    if (number > 4 || number < 1)
        return;
    str = g_strdup_printf("livewp-home-widget.desktop-%i", (number - 1));
    config_file = hd_config_file_new(NULL, "/home/user/.config/hildon-desktop/", "home.plugins");
    
    gkey_file = hd_config_file_load_file(config_file, FALSE);
    if (gkey_file){
         g_key_file_remove_group(gkey_file, str, NULL);  
        hd_config_file_save_file( config_file, gkey_file);
        g_key_file_free(gkey_file);
    }else
        fprintf(stderr, "Problem with config file");
    if (str)
        g_free(str);
    g_object_unref(config_file);

}
