/* vim: set sw=4 ts=4 et: */
/*
 * This file is part of Live Wallpaper (livewp)
 * 
 * Copyright (C) 2010 Vlad Vasiliev
 * Copyright (C) 2010 Tanya Makova
 *       for the code
 * 
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 * 
 * This software is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
*/
/*******************************************************************************/
#include "livewp-config.h"
/*******************************************************************************/
gint 
read_config(Animation_WallpaperPrivate *priv) {

    GConfClient *gconf_client = NULL;
    gchar *tmp = NULL;
    GConfValue *value = NULL;

    gconf_client = gconf_client_get_default();
    if (!gconf_client) {
        fprintf(stderr, _("Failed to initialize GConf. Quitting.\n"));
        return -1;
    }
    /* get Theme default Modern */
    tmp = gconf_client_get_string(gconf_client,
                                  GCONF_KEY_THEME, NULL);
    if (tmp){
        priv->theme = tmp;
    }else
        priv->theme = g_strdup("Modern");
    /* get Rich animation default TRUE */
    value = gconf_client_get(gconf_client, GCONF_KEY_RANIMATION, NULL);
    if (value) {
        priv->rich_animation = gconf_value_get_bool(value);
        gconf_value_free(value);
    } else
        priv->rich_animation = TRUE;

    return 0;
}

/*******************************************************************************/
void
save_config(Animation_WallpaperPrivate *priv) {

    GConfClient *gconf_client;
    gconf_client = gconf_client_get_default();
    if (!gconf_client) {
        fprintf(stderr, _("Failed to initialize GConf. Quitting.\n"));
        return;
    }
    /* Save Weather source name. */
    if (priv->theme)
        gconf_client_set_string(gconf_client,
                  GCONF_KEY_THEME,
                  priv->theme, NULL);
    if (priv->rich_animation)
        gconf_client_set_bool(gconf_client,
                              GCONF_KEY_RANIMATION, TRUE, NULL);
    else
        gconf_client_set_bool(gconf_client,
                              GCONF_KEY_RANIMATION, FALSE, NULL);

}
