
#include <time.h>			// req for sleep
#include <sys/time.h>		// req for getticks

#include <stdio.h>
#include <stdlib.h>
#include <netdb.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <stdarg.h>
#include <string.h>
#include <sys/sysinfo.h>

#include <strings.h>


#include <liqbase/liqcell.h>
#include <liqbase/liqcell_prop.h>
#include <liqbase/liqcell_easyrun.h>
#include <liqbase/liqimage.h>
#include <liqbase/liqsketch.h>
#include <liqbase/liq_xsurface.h>

#include <liqbase/liqapp_prefs.h>

#include "liqcell_textrecordparse.h"

	static int widget_click(liqcell *self, liqcellclickeventargs *args, liqcell *liqirc)
	{
		 args->newdialogtoopen = liqcell_hold( liqcell_getcontent( self ) );
		 return 1;
	}


liqcell *liqirc_findorcreatechan(liqcell *liqirc,char *channame)
{
	liqcell *backplane = liqcell_child_lookup(liqirc, "backplane");
	liqcell *item = liqcell_child_lookup(backplane, channame);
	if(!item)
	{
		liqcell *chan = liqcell_quickcreatevis(channame, "liqircchan", 0, 0, 800,480);
		//liqcell_child_append(  backplane, chan);
		
		liqircchan_additem(chan, "00:00", "NEW" , liqirc->tag  );

		item = liqcell_quickcreatevis(channame, NULL, 0,0,1,1);
		 liqcell_propseti(item,"lockaspect",1);
		 liqcell_setcontent(item,	 chan);
		 liqcell_handleradd_withcontext(item,	 "click",	widget_click,liqirc);
		 liqcell_child_append( backplane, item );
		 
		 liqcell_setdata(chan,liqirc);

		if(liqcell_child_countvisible(backplane)<12)
		{
			liqcell_child_arrange_easytile(backplane);
		}
		else
		{
			liqcell_child_arrange_makegrid(backplane,4,4);
		}
	}
	return liqcell_getcontent(item);
}


int liqirc_linesplit(liqcell *liqirc,char *line)
{
	
	liqcell_setdirty(liqirc,1);
	
	liqcell *backplane = liqcell_child_lookup(liqirc, "backplane");

	liqirc->tag=line;

	char *cursor=line;
	liqcell *rec=NULL;

	if( (rec=liqcell_textrecordparse(cursor,":[from_nick]!i=[from_id] PRIVMSG #[to_chan] :[msg]")) ||
	    (rec=liqcell_textrecordparse(cursor,":[from_nick]!n=[from_id] PRIVMSG #[to_chan] :[msg]"))
	  )
	{
		// general message into chan
		// enumerate the visible channels
		// create a new one if required
		// add this message to it
		
		// make sure this is tapered correctly
		char buf[128];
		snprintf(buf,sizeof(buf),"#%s",liqcell_propgets(rec,"to_chan",""));
		liqcell_propsets(rec,"to_chan",buf  );

		liqcell *chan = liqirc_findorcreatechan(liqirc, liqcell_propgets(rec,"to_chan","") );
		liqircchan_additem(chan, "00:00", liqcell_propgets(rec,"from_nick","anon") , liqcell_propgets(rec,"msg","nomsg")  );

		
		//liqcell_handlerrun(liqirc, "line_recv", liqcell_propgets(rec,"msg","nomsg") );
		//liqcell_print(rec,"liqirc: MSG ",2);
		liqcell_release(rec);	
		return 1;
	}	

	if( (rec=liqcell_textrecordparse(cursor,":[from_nick]!i=[from_id] PRIVMSG [to_nick] :[msg]")) ||
	    (rec=liqcell_textrecordparse(cursor,":[from_nick]!n=[from_id] PRIVMSG [to_nick] :[msg]"))
	  )
	{
		// private conversation
		// enumerate the current channels
		// create a new one if required
		// add this message to it
		liqcell *chan = liqirc_findorcreatechan(liqirc, liqcell_propgets(rec,"from_nick","") );
		liqircchan_additem(chan, "00:00", liqcell_propgets(rec,"from_nick","anon") , liqcell_propgets(rec,"msg","nomsg")  );
		
		
		//liqcell_handlerrun(liqirc, "line_recv", liqcell_propgets(rec,"msg","nomsg") );
		//liqcell_print(rec,"liqirc: PM  ",2);
		
		
		liqcell_release(rec);
		return 1;
	}	
	
	if( (rec=liqcell_textrecordparse(cursor,":[from_nick]!i=[from_id] JOIN :#[to_chan]")) ||
	    (rec=liqcell_textrecordparse(cursor,":[from_nick]!n=[from_id] JOIN :#[to_chan]"))
	  )
	{
		// someone joined a specific chan
		// enumerate the current channels
		// create a new one if required
		// add this user to it		
		//liqcell_print(rec,"liqirc: JOIN ",2);

		char buf[128];
		snprintf(buf,sizeof(buf),"#%s",liqcell_propgets(rec,"to_chan",""));
		liqcell_propsets(rec,"to_chan",buf  );

		liqcell *chan = liqirc_findorcreatechan(liqirc, liqcell_propgets(rec,"to_chan","") );
		liqircchan_additem(chan, "00:00", liqcell_propgets(rec,"from_nick","anon") , "Joined!"  );

		liqcell_release(rec);
		return 1;
	}

	
	



	
	if(rec=liqcell_textrecordparse(cursor,":[from_serv] [%code_number] [to_nick] @ #[to_chan] :[msg]"))
	{
		// user list for channel
		// enumerate the current channels
		// create a new one if required
		// using the channel specified [to_chan] clear and rebuild the user list
		//liqcell_print(rec,"liqirc: USRS",2);
		liqcell_release(rec);
		return 1;
	}
	if(rec=liqcell_textrecordparse(cursor,":[from_serv] [%code_number] [to_nick] [msg]"))
	{
		// intro stuff
		// add to general chan :)
		
		//liqcell *chan = liqirc_findorcreatechan(liqirc, liqcell_propgets(rec,"to_nick","") );
		liqcell *chan = liqirc_findorcreatechan(liqirc, "@@local");
		liqircchan_additem(chan, "00:00", liqcell_propgets(rec,"from_serv","anon") , liqcell_propgets(rec,"msg","nomsg")  );

		
		//liqcell_handlerrun(liqirc, "line_recv", liqcell_propgets(rec,"msg","nomsg") );
		//liqcell_print(rec,"liqirc: head",2);
		liqcell_release(rec);
		return 1;
	}

		liqcell *chan = liqirc_findorcreatechan(liqirc, "@@local" );
		liqircchan_additem(chan, "00:00", "SERVER" , line  );

		//liqcell_handlerrun(liqirc, "line_recv", line );
}






void liqirc_sendserv(liqcell *liqirc,char *str, ...)
{
	int sock=0;
	
	sock=liqcell_propgeti(liqirc,"liqirc_sock",0);
	



	if(!sock)
	{
		liqapp_log("liqirc: cannot send, no sock");
		return;
	}

    va_list tmpl;
    char tmp[1024];

    va_start(tmpl,str);
    vsprintf(tmp,str,tmpl);
    va_end(tmpl);
	
	liqapp_log("liqirc: sending to sock %i: '%s'",sock,tmp);
	
    //strcat(tmp,"\r\n");
    strcat(tmp,"\n");

    send(sock,tmp,strlen(tmp),0);
	//liqapp_log("liqirc: sent    to sock %i: '%s'",sock,tmp);

}



// liqirc session.

int liqirc_session(liqcell *liqirc, char *liqirc_server,int liqirc_port)
{

int connected;	
struct sockaddr_in 		sck;
struct hostent *		hent;

int   sock=0;
FILE *in=NULL;
FILE *out=NULL;

	liqcell_propremovei(liqirc,"liqirc_sock");
	if(!liqirc_server || *liqirc_server==0)
	{
		//liqapp_log("liqirc: no server configured, cannot connect");
		return 0;
		
	}
   
	liqapp_log("liqirc: preparing to connect to: '%s'",liqirc_server);
   
	
     connected = 0;
    memset((char *)&sck, 0, sizeof(sck));
	
	liqapp_log("liqirc: looking up server: '%s'",liqirc_server);
    hent = gethostbyname(liqirc_server);
	
    if(hent == NULL)
    {
        liqapp_log("liqirc: error could not connect to '%s'",liqirc_server);
        return -1;
    }
	//###########################################
	liqapp_log("liqirc: found host, creating socket..");
    
    memcpy((char *)&sck.sin_addr,hent->h_addr,hent->h_length);
    sck.sin_family=hent->h_addrtype;
    sck.sin_port=htons(liqirc_port);
    sock=socket(PF_INET,SOCK_STREAM,0);
	
    if (sock < 0)
    {
        liqapp_log("liqirc: error could not create socket");
        return -2;
    }
	
	//###########################################
	liqapp_log("liqirc: socket created, connecting..");
    
    if (connect(sock,(struct sockaddr *)&sck,sizeof(sck)) < 0)
    {
        liqapp_log("liqirc: error could not connect");
        return -3;
    }
	
	//###########################################
    liqapp_log("liqirc: connected! ");
	
    in=fdopen(sock,"r");
    out=fdopen(sock,"w");
	liqcell_propseti(liqirc,"liqirc_sock",sock);
 
	//###########################################
    liqapp_log("liqirc: setting TCP_NODELAY! (fast action, instant send");
	
	#define TCP_NODELAY 0x01

	//http://www.unixguide.net/network/socketfaq/2.16.shtml

	int flag = 1;
	int result = setsockopt(sock,            // socket affected
							IPPROTO_TCP,     // set option at TCP level
							TCP_NODELAY,     // name of option
							(char *) &flag,  // the cast is historical cruft
							sizeof(int));    // length of option value
	if (result < 0)
	{
		//... handle the error ...
	    liqapp_log("liqirc: error setting TCP_NODELAY");
	    return -4;
	}

	//###########################################
    
    // irc over telnet :)
    // http://oreilly.com/pub/h/1963
	
	char rawnick[64];
	snprintf(rawnick,sizeof(rawnick),"%s", app.username);
	if(strcasecmp(rawnick,"user")==0 || *rawnick=='\0')
	{
		srand ( time(NULL) );
		snprintf(rawnick,sizeof(rawnick),"liquser%i", rand() % 65535);
		liqapp_pref_setvalue("ircnick",rawnick);
		liqapp_prefs_save();
	}

    liqirc_sendserv(liqirc,"NICK %s",                liqapp_pref_getvalue_def("ircnick",rawnick)          );
    liqirc_sendserv(liqirc,"USER %s \"\" \"%s\" :%s",liqapp_pref_getvalue_def("ircnick",rawnick)
                                                    ,liqapp_pref_getvalue_def("ircserver","irc.freenode.net")
                                                    ,liqapp_pref_getvalue_def("ircnick",rawnick)
                                                    );
    
  
 	//###########################################
    
    liqapp_log("liqirc: connect event");
    liqcell_handlerrun(liqirc,"connect",NULL);
    liqapp_log("liqirc: connect event complete");
	
	//###########################################
	liqapp_log("liqirc: joining channel");	
    liqirc_sendserv(liqirc,"JOIN %s",                liqapp_pref_getvalue_def("ircchan","#liqbase-test")          );
	
	//###########################################
	liqapp_log("liqirc: processing loop");
	

	char linebuf[1024] = {0};
    do
    {
        linebuf[0]=0;
        char *line=fgets(linebuf,1024,in);
        if(line && *line)
        {
             linebuf[1023]=0;
            //
            char *t=line;
            while(*t){ if(*t==10 || *t==13)*t=0;  t++; }
			

            
            
            if(strncasecmp(line,"ping ",5)==0)
            {
                liqirc_sendserv(liqirc,"PONG %s",&line[5]);
            }
            else
            {
                // regular line
	            liqapp_log("liqirc: in '%s'",line);  			
				liqirc_linesplit(liqirc,linebuf);              
                //liqcell_handlerrun(liqirc,"line_recv",line);
            }
            
        }
        //splitline(sock,liqtactoe);
        //parseline(sock,liqtactoe);
    }
    while(linebuf[0]!='\0');
	
	liqcell_propremovei(liqirc,"liqirc_sock");
	
	//###########################################
	liqapp_log("liqirc: processing loop completed.");
 
 	//###########################################
	liqapp_log("liqirc: close connections and release sockets");
    fclose(in);
    fclose(out);
    close(sock);
	
    
 	//###########################################
    
    liqapp_log("liqirc: disconnect event");
    liqcell_handlerrun(liqirc,"disconnect",NULL);
    liqapp_log("liqirc: disconnect event complete");
    
 	//###########################################
	liqapp_log("liqirc: completed");
	
	return 0;
}


/**	
 * handle the timer to fire the session off
 */	

static int liqirc_timer1_tick(liqcell *self, liqcellmouseeventargs *args, void *liqirc)
{
    liqcell_propseti(self,"timerinterval", 32767 );
    liqcell_setenabled(self,0);
    while(1)
    {
        
        liqirc_session( liqirc,
                                    liqapp_pref_getvalue_def("ircserver","irc.freenode.net") ,
                               atoi(liqapp_pref_getvalue_def("ircport",  "6667"))
                               );
        
        liqapp_sleep(       atoi(liqapp_pref_getvalue_def("ircreconnectdelay",  "30000"))     );
    }

    return 0;
}


/**	
 * create a new liqirc widget
 */	
liqcell *liqirc_create()
{
	liqcell *self = liqcell_quickcreatewidget("liqirc", "form", 800, 480);
	if(!self) {liqapp_log("liqcell error not create 'liqirc'"); return NULL;  }
	
	
	//############################# backplane:picturebox
	liqcell *backplane = liqcell_quickcreatevis("backplane", "picturebox", 0, 0, 800, 480);
	liqcell_child_append(  self, backplane);
			
    //############################# timer1:liqtimer
    liqcell *timer1=liqcell_quickcreatevis("timer1",   "liqtimer",   0,0,   0,0 );
    liqcell_propseti(timer1,"timerinterval", 25 );
    liqcell_handleradd_withcontext(timer1,"timertick",liqirc_timer1_tick,self);
    liqcell_setenabled(timer1,1);
    liqcell_child_insert( self,timer1);
    
    // non visual
   // liqcell_setvisible( self,0);
    return self;
}
		

