#include <time.h>			// req for sleep
#include <sys/time.h>		// req for getticks

#include <stdio.h>
#include <stdlib.h>
#include <netdb.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <stdarg.h>
#include <string.h>
#include <sys/sysinfo.h>

#include <strings.h>


#include <liqbase/liqcell.h>
#include <liqbase/liqcell_prop.h>
#include <liqbase/liqcell_easyrun.h>
#include <liqbase/liqimage.h>
#include <liqbase/liqsketch.h>
#include <liqbase/liq_xsurface.h>

#include <liqbase/liqapp_prefs.h>


static liqcell *template_parse(char *template)
{
	// we must break the template into its fragments

	char *cursor=template;
	liqcell *res=NULL;
	void res_add(char *kind,char *s,char *e)
	{
		if(!res)
		{
			res=liqcell_quickcreatenameclass(template,"template");
		}
		if(res)
		{
			char *buf=strndup(s,(e-s));
			if(buf)
			{
				//liqapp_log("irc: tok '%s'='%s'",kind,buf);
				liqcell * c = liqcell_quickcreatenameclass(buf,kind);
				liqcell_child_append(res,c);
				free(buf);
			}
		}
	}
	while(*cursor)
	{
		// identify everything leading upto '[' as a single constant pattern
		char *pres=cursor;
		char *pree=cursor;
		while(*cursor && *cursor!='[')
		{
			cursor++;
			pree++;
		}
		if(pres<pree)  res_add("const",pres,pree);
		// now, handle the entire field in one go
		if(*cursor=='[')
		{
			// starting a field
			cursor++;
			char *fs=cursor;
			char *fe=cursor;
			while(*cursor)
			{
				if(*cursor==']')
				{
					// ended field
					cursor++;
					break;
				}
                cursor++;
				fe++;
			}
			if(fs<fe)   res_add("token",fs,fe);
		}
	}
	return res;
}
				
				

liqcell * liqcell_textrecordparse(char *indat,char *template)
{
	// parse the line and produce a record of data from the given template
	// return the completed cell, or nothing
	
	char *cursor=indat;
	liqcell *res=NULL;
	
	void res_add_head()
	{
		if(!res)
		{
			res=liqcell_quickcreatenameclass(template,"record");
			//liqcell_propsets(res,"_indat",indat);
			//liqcell_propsets(res,"_template",template);
		}
	}
	void res_add(char *fieldname,char *s,char *e)
	{
		res_add_head();
		if(res)
		{
			char *buf=strndup(s,(e-s));
			if(buf)
			{
				//liqapp_log("record_parse: field '%s'='%s'",fieldname,buf);
				
				//liqcell * c = liqcell_quickcreatecaption(fieldname,"field",buf);
				//liqcell_child_append(res,c);
				liqcell_propsets(res,fieldname,buf);
				free(buf);
			}
		}
	}
	//##########################################
	// we must break the line into its fragments
	liqcell *template_row = template_parse(template);
	if(!template_row)
	{
		liqapp_log("record_parse: there was a problem obtaining the template");
		return NULL;
	}
	//##########################################
	// now, we must cycle around the template building up results as we go
	liqcell *tok = liqcell_getlinkchild(template_row);
	while(tok)
	{
		liqcell *toknxt = liqcell_getlinknext(tok);
		// figure out what kind of tok this is
		if(strcasecmp(tok->classname,"const")==0)
		{
			//liqapp_log("record_parse: try const '%s' on '%s'",tok->name,cursor);
			// need to match constant...
			if( stristr(cursor,tok->name)==cursor )
			{
				//liqapp_log("record_parse: found tok '%s' == input '%s'",tok->name,cursor);

				// matched :)
				res_add_head();
				cursor+=strlen(tok->name);
			}
			else
			{
				//liqapp_log("record_parse: mismatch tok '%s' != input '%s'",tok->name,cursor);
				if(res)liqcell_release(res);
				if(template_row)liqcell_release(template_row);
				return NULL;
			}
		}
		else
		if(strcasecmp(tok->classname,"token")==0)
		{
			//liqapp_log("record_parse: try token '%s' on '%s'",tok->name,cursor);
			// need to match field...
			// so we mark ourselves and jump until we hit on the next const
			
			
			if(tok->name[0]=='%')
			{
				if(isdigit(*cursor))
				{
					char *e=cursor;
					while(	isdigit(*e) )
					{
						e++;
					}
					res_add(&tok->name[1],cursor,e);
					cursor=e;
				}
				else
				{
					//liqapp_log("record_parse: number expected");
					if(res)liqcell_release(res);
					if(template_row)liqcell_release(template_row);
					return NULL;					
				}
			}
			else
			if(tok->name[0]=='$')
			{
				while(*cursor==' ')cursor++;
				char *e=cursor;
				while(*e && *e != ' ')e++;
				res_add(&tok->name[1],cursor,e);
				cursor=e;
			}
			else
			if(toknxt)
			{
				if(strcasecmp(toknxt->classname,"const")==0)
				{
					char *t = stristr(cursor,toknxt->name);
					if(t)
					{
						// everything from cursor..t is the field :)
						// we then skip past t and advance toknxt
						
						res_add(tok->name,cursor,t);
						cursor=t+strlen(toknxt->name);
						
						toknxt = liqcell_getlinknext(toknxt);
					}
					else
					{
						//liqapp_log("record_parse: not found");
						if(res)liqcell_release(res);
						if(template_row)liqcell_release(template_row);
						return NULL;
					}
				}
				else
				{
					//liqapp_log("record_parse: invalid nxt type");
					if(res)liqcell_release(res);
					if(template_row)liqcell_release(template_row);
					return NULL;
				}
			}
			else
			{
				// we grab everything to the end of the input and make a branch with it
				char *t=cursor + strlen(cursor);
				res_add(tok->name,cursor,t);
				cursor=t;
			}
		}
		tok=toknxt;
	}
		
	if(res)
	{
		liqcell_propseti(res,"_len",(cursor-indat) );
		char *buf=strndup(indat,(cursor-indat));
		if(buf)
		{
			//liqcell_propsets(res,"_all",buf);
			liqcell_setname(res,buf);
			free(buf);
		}
	}


	return res;
}
