#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <dirent.h>



#include "liqapp.h"
#include "liqcanvas.h"
#include "liqimage.h"
#include "liqfont.h"
#include "liqtile.h"



#include "mk_core.h"


#include "liqnet.h"


PAGE *fontpages[256]={NULL};

void dddd()
{
	//x("tools(options,zoom,select,delete,new)");
	
	// must also be able to change the toolkit
}


//#######################################################################
//#######################################################################
//#######################################################################
//#######################################################################



typedef struct xfont
{
	// font generated from sketches
	// stored at default orientation only, 
	int usagecount;
	
	PAGE *glyphs[256];
	
	int glyphwidths[256];

	int maxw;
	int maxh;
	
	int avgw;
	
	int dpix;
	int dpiy;
}
	xfont;

int xfont_configure(xfont *self,int dpix,int dpiy)
{
	int idx;
	for(idx=0;idx<256;idx++)
	{
		self->glyphs[idx]=0;
		self->glyphwidths[idx]=0;
	}
	
	self->dpix=dpix;
	self->dpiy=dpiy;
	
	self->avgw=0;
	
	self->maxw=0;
	self->maxh=0;
	return 0;
}
int xfont_addglyph_size(xfont *self,unsigned char glyph,PAGE *glyphdata,int uw,int uh)
{
	self->glyphs[glyph] = glyphdata;
	self->glyphwidths[glyph] = uw;
	if(uw>self->maxw)self->maxw=uw;
	self->avgw=(self->avgw+uw)/2;
	if(uh>self->maxh)self->maxh=uh;
}

int xfont_addglyph(xfont *self,unsigned char glyph,PAGE *glyphdata)
{
	int uw = glyphdata->boundingbox.xr-glyphdata->boundingbox.xl;
	int uh = glyphdata->boundingbox.yb-glyphdata->boundingbox.yt;
	xfont_addglyph_size(self,glyph,glyphdata);
}



int xfont_filesave(xfont *self,char *filename)
{
	FILE * fd = fopen(filename,"w");
	if(!fd)
	{
		app_log("xfont_filesave: couldn't open '%s' for writing",filename);
		return -1;
	}
		app_log("xfont_filesave: creating '%s'",filename);
	
											fprintf(fd,"xfont\n");
											fprintf(fd,"size:%i,%i\n",self->maxw,self->maxh);
											fprintf(fd,"dpi:%i,%i\n",self->dpix,self->dpiy);
	
	int idx;
	for(idx=0;idx<256;idx++)
	{
		if(self->glyphs[idx])
		{
		app_log("xfont_filesave: writing '%s': %i",filename,idx);


			//
											fprintf(fd," ch:%i,%i\n",idx,self->glyphwidths[idx]);
			PAGE *pg=self->glyphs[idx];
			STROKE *s = pg->strokefirst;
			while(s)
			{
				//
											fprintf(fd,"  st:%i,%i,%i\n",s->pen_y,s->pen_u,s->pen_v);
				POINT *p=s->pointfirst;
				while(p)
				{
					//
											fprintf(fd,"   pt:%i,%i,%i\n",p->x,p->y,p->z);
					p=p->linknext;
				}
				s=s->linknext;
			}
		}
	}
	
	fclose(fd);

		app_log("xfont_filesave: finished '%s'",filename);

}	















int xfont_fileload(xfont *self,char *filename)
{
	app_log("xfont_fileload '%s'",filename);
	struct doc doc;
	int err=0;
	
	doc.renderfont=NULL;
	
	err=doc_initfromfilename(&doc,filename);
	if(err)
	{
    	{ return app_warnandcontinue(-1,"xfont_fileload couldnt open"); }						
	}
	int linenum=1;	
	struct docline *docline = doc.linefirst;
	if(!docline)
	{
		// empty file
		doc_close(&doc);
	   	{ return app_warnandcontinue(-1,"xfont_fileload file is empty"); }						
	}

	if(strncmp(docline->linedata,"xfont",5) != 0)
	{
		// invalid header
		doc_close(&doc);
	   	{ return app_warnandcontinue(-1,"xfont_fileload invalid file header"); }
	}

	PAGE *  pg = NULL;
	STROKE *st = NULL;
	POINT * pt = NULL;
	
	
	xfont_configure(self,225,255);		// use default


	while(docline)
	{
		//app_log("trying line: %5i %s",linenum,indat);
		// a line is "cmd:arg,arg,arg"
		// different cmds do different things
		char *indat = docline->linedata;
		char *colon = strchr(indat,':');
		if(!colon)
		{
			// this is an invalid line
		}
		else
		{
			// now we can break into comma delims
			// this is destructive to the memory, we null as we go along..
			colon = '\0';
			char *xcmd = indat;
			char *xcols[80+1];
			int   xcolcount=0;
			indat = colon+1;
			xcols[0] = indat;
			xcolcount++;
			while(*indat && xcolcount<80)
			{
				if(*indat=='.')
				{
					*indat=0;
					indat++;
					xcols[xcolcount++]=indat;
				}
				else
					indat++;
			}
			// ok, sorted, now we have a really quick simple bit of parsing to do :)
			// rotate this round so the most frequent items are compared first
			if((strcmp(xcmd,"size")==0) && xcolcount==2)
			{
				self->maxw = atoi( xcols[0]) );
				self->maxh = atoi( xcols[1]) );
			}
			else
			if((strcmp(xcmd,"dpi")==0) && xcolcount==2)
			{
				self->dpix = atoi( xcols[0]) );
				self->dpiy = atoi( xcols[1]) );
			}
			else
			if((strcmp(xcmd,"ch")==0) && xcolcount==2)
			{
				//
				// ok, gonna define a glyph

				pg = page_alloc();
				pg->pixelwidth=atoi( xcols[1]) );
				pg->pixelheight=self->maxh;
				pg->dpix=self->dpix;
				pg->dpiy=self->dpiy;
				st = NULL;
				pt = NULL;
				
				//
				xfont_addglyph_size(self,  (unsigned char)atoi( xcols[0]) ),  pg,  pg->pixelwidth,  pg->pixelheight);

			}
			else
			if((strcmp(xcmd,"st")==0) && xcolcount==3)
			{
				st = stroke_alloc();
				st->pen_y = (unsigned char) atoi( xcols[0]) );
				st->pen_u = (unsigned char) atoi( xcols[1]) );
				st->pen_v = (unsigned char) atoi( xcols[2]) );
			}
			else
			if((strcmp(xcmd,"pt")==0) && xcolcount==3)
			{
				if(st->pointcount==0)
				{
					stroke_start(s,
								 (unsigned char) atoi( xcols[0]) ),
								 (unsigned char) atoi( xcols[1]) ),
								 (unsigned char) atoi( xcols[2]) )
								 );
					page_strokeinsert(pg,st);
				}
				else
				{		
					stroke_extend(s,
								 (unsigned char) atoi( xcols[0]) ),
								 (unsigned char) atoi( xcols[1]) ),
								 (unsigned char) atoi( xcols[2]) )
								 );
					page_strokeupdate(pg,st);					
				}
				
			}
			else
			{
				// invalid command
			}
		}
		docline=docline->linknext;
		linenum++;
	}
	doc_close(&doc);
	
	return 0;
}























































































int xfont_textfitinside(xfont *self,char *data,int availablewidth)
{
	int tot=0;
	int fit=0;
	while(*data)
	{
		tot+=self->glyphwidths[*data++];
		if(tot>=availablewidth) return fit;
		fit++;
	}
	return fit;	
}
int xfont_textwidth(    xfont *self,char *data)
{
	int tot=0;
	while(*data)
	{
		tot+=self->glyphwidths[*data++];
	}
	return tot;
}
int xfont_textwidthn(   xfont *self,char *data,int datalen)
{
	int tot=0;
	while(*data && datalen>0)
	{
		tot+=self->glyphwidths[*data++];
		datalen--;
	}
	return tot;
}




float xfont_calcaspect(int captionw,int captionh,int availw,int availh)
{
	if(captionw==0)return 0;
	if(captionh==0)return 0;
	float ax = (float)availw / (float)captionw;
	float ay = (float)availh / (float)captionh;
	float ar = (ax<=ay ? ax : ay);


	//app_log("from %i,%i",captionw,captionh);
	//app_log("to   %i,%i",availw,availh);
	//app_log("ax   %f,%f,%f",ax,ay,ar);
	
	
	return ar;
	
}


int xfont_textrender(xfont *font,cliprect *cr,int xs,int ys,int availw,int availh,char *data)
{
	
	int captionw = xfont_textwidth(font,data);
	int captionh = font->maxh;
	
	float ar = xfont_calcaspect(  captionw,captionh,  availw,availh);
	
	int x=xs;
	int h=(int)(    ((float)captionh) * ar      );
	
	unsigned char ch;
	while ( (ch=*data++) )
	{
		int w= (int)(     ((float)font->glyphwidths[ch]) * ar );
		//if((w>0) && font->glyphs[ch])
		if(font->glyphs[ch])
		{
			//app_log("tr p=%i,%i  f=%i,%i    ar=%f",x,ys,w,h,ar);
			cliprect_drawpage(cr,        font->glyphs[ch],x,ys,w,h,  0 );
			//cliprect_drawboxlinecolor(cr,                 x,ys,w,h,  255,128,128 );
		}
		x+=w;
	}
	return x;
}



void xfont_test()
{

	xfont fontcore;
	xfont *font=&fontcore;
	xfont_configure(font,canvas.dpix,canvas.dpiy);
	
	
	int idx;
	for(idx=0;idx<256;idx++)
	{
		if(fontpages[idx])
		{
			xfont_addglyph(font,(char)idx,fontpages[idx]);
		}
	}
	
	font->glyphwidths[9 ] = font->avgw * 4;
	font->glyphwidths[32] = font->avgw;
	
	
	xfont_textrender(font,canvas.cr,0,0,canvas.pixelwidth,100,"mary had a little lamb, its fleece was white as snow.");
	
	
	
	xfont_filesave(font,"_mytestfont.xfont");
	
}	
	
	
	
	
//#########################################################################
//#########################################################################
//######################################################################### cell construction and reference counting
//#########################################################################
//#########################################################################

xfont *xfont_new()
{
	// use this to allocate and hold onto a reference
	// should really overload this and allow variations..
	xfont *self = (STROKE *)malloc(sizeof( xfont ));
	memset((char *)self,0, sizeof( xfont ));
	self->usagecount=1;
	return self;
}

void xfont_hold(xfont *self)
{
	// use this to hold onto an object which someone else created
	self->usagecount++;
}

void xfont_release(xfont *self)
{
	// use this when you are finished with an object
	self->usagecount--;
	if(!self->usagecount) xfont_free(self);
}

void xfont_free(xfont *self)
{
	// never call _free directly, outside sources should _release the object
	int idx;
	for(idx=0;idx<256;idx++)
	{
		if(self->glyphs[idx])
		{
			page_free(self->glyphs[idx]);
			self->glyphs[idx] = NULL;
		}
	}
	free(self);
}












//############################################################### test code


#define SERVERPORT	18585
#define SERVERHOST 	"liquid.zapto.org"

int senddata(char *buff)
{
	liqnet netroot = {0};
	int e=0;
	e=liqnet_connect(&netroot,SERVERHOST,SERVERPORT);
	if(e==0)
	{
		// connected..
		// todo: respond on every e, find a nice way to handle this
		e=liqnet_sendtext(&netroot,"<data>");
		e=liqnet_sendtext(&netroot," <user>gary</user>");
		e=liqnet_sendtext(&netroot,  buff);
		e=liqnet_sendtext(&netroot,"</data>");
		e=liqnet_disconnect(&netroot);
	}
}

//############################################################### idea code

liqtile *mkmenuitem(char *title,int tag,void (*click_handler)())
{
		liqtile *titem=liqtile_createquick(title,0,0,100,100);
		titem->style=stylemenuitemstd;
		titem->handlerclick=click_handler;
		titem->tag = tag;
		return titem;
}


int runfast=0;

static liqtile *tileroot=NULL;
static liqtile *tilepage=NULL;

// read a definition file and create that tree


	int btn_save(struct liqtile *self)//,liqtileeventmouse *args)
	{
		app_log("Event save");
		liqtile* c=tilepage->linkchild;
		// create the strokes now for the library
		while(c)
		{
			if(c->linkpage)
			{
				int bbl = c->linkpage->boundingbox.xl;
				int bbr = c->linkpage->boundingbox.xr;
				
				int bbt = c->linkpage->boundingbox.yt;
				int bbb = c->linkpage->boundingbox.yb;


				PAGE *pg=fontpages[c->tag];
				if(pg)
				{
					// free it?
					page_free(pg);
					pg=NULL;
				}
				pg = page_clone(c->linkpage);
				
				// should really expand to at least the specified ratio of the glyph..
				
				//page_boundto(pg,c->w,c->h);
/*				page_boundtouchpoint(pg,bbl-5,0);
				page_boundtouchpoint(pg,bbr+5,0);
				
				page_boundtouchpoint(pg,bbl-5,self->h);
				page_boundtouchpoint(pg,bbr+5,self->h);
*/

				page_boundtouchpoint(pg,bbl-0,0);
				page_boundtouchpoint(pg,bbr+0,0);
				
				page_boundtouchpoint(pg,bbl-0,self->h);
				page_boundtouchpoint(pg,bbr+0,self->h);




				fontpages[c->tag] = pg;
			}
			c=c->linknext;
		};
		
		//running=0;
		return 1;
	}
	
	int btn_cancel(struct liqtile *self)//,liqtileeventmouse *args)
	{
		app_log("Event cancel");
		//running=0;
		return 1;
	}
	



static int glyph_paint(struct liqtile *self,liqtileeventpaint *args)
{	
int x=args->ox+self->x;
int y=args->oy+self->y;




		while(!feof(stdin))
		{
			int ch = getc(stdin);
			if(ch==EOF) break;
			char s[2];
			s[0]=ch;
			s[1]=0;
			app_log("STDIN: %i '%s'",(int)ch,s);
		}
		


	if(self->linkpage)
	{
		int bbl = self->linkpage->boundingbox.xl;
		int bbr = self->linkpage->boundingbox.xr;
		
		int bbt = self->linkpage->boundingbox.yt;
		int bbb = self->linkpage->boundingbox.yb;
		
		
		//cliprect_drawboxfillcolor(args->cr, x    ,y+bbt-5, self->w, bbb-bbt+10 , 10,120,120);
		cliprect_drawboxfillcolor(args->cr, x+bbl-5    ,y, bbr-bbl+10, self->h , 10,120,120);
	}


		cliprect_drawboxfillcolor(args->cr, x,y+self->h * 0.3, self->w,self->h*0.4 , 20,128,128);

	if(self->linkpage)
	{
	
		
		int w=self->linkpage->pixelwidth;
		int h=self->linkpage->pixelheight;
		
		cliprect_drawpage(args->cr, self->linkpage, x,y, w,h ,2);
		//cliprect_drawpage(args->cr, self->linkpage, x,y, w,h ,0);
		
		cliprect_drawboxlinecolor(args->cr, x,y              , self->w,self->h     , 80,100,100);
		
	}
	else
	{
		cliprect_drawboxlinecolor(args->cr, x,y              , self->w,self->h     , 40,100,100);
	}

	self->handlerpaint=NULL;
	liqtile_rendertocanvascr(self,args->ox,args->oy,NULL,args->cr);
	self->handlerpaint=glyph_paint;

	return 0;
}




static int modelayout=0;
	int btn_liqbase(struct liqtile *self)//,liqtileeventmouse *args)
	{
		if(modelayout)
			modelayout=0;
		else
			modelayout=1;
		return 0;
	}	

static int glyph_mouse(struct liqtile *self,liqtileeventmouse *args)
{
	
	
		if(modelayout)
		{
			self->x-=args->mdx;
			self->y-=args->mdy;
			liqtile_update_boundfrompos(self);
			liqtile_overlapcalc(self->linkparent,self);
			return 0;
		}
		
		
	PAGE *pg=self->linkpage;
	
	if(!pg)
	{
		app_log("glyph: making page");
		
		pg = page_alloc();
		pg->pixelwidth=canvas.pixelwidth;
		pg->pixelheight=canvas.pixelheight;
		pg->dpix=canvas.dpix;
		pg->dpiy=canvas.dpiy;
		
		if(!pg)
		{
			app_log("glyph_mouse: could not alloc linkpage");
			return -1;
		}
		self->linkpage=pg;
		app_log("glyph: linked page");
	}
	
	// find out if we are inside
	int ox = 0;
	int oy = 0;
	
	liqtile_getabsoluteoffset(self,&ox,&oy);

	int mx = args->mex-ox;
	int my = args->mey-oy;
	
	
	// i dont bail, i clip
	
	if(mx<0)mx=0;
	if(mx>self->w)mx=self->w-1;
	
	if(my<0)my=0;
	if(my>self->h)my=self->h-1;
		
	
	STROKE *s;
	if(args->mcnt==1 || (self->linkpage->strokelast==NULL))
	{
		//app_log("glyph: stroke alloc");
		// start a stroke
			s = stroke_alloc();
			s->pen_y=255-self->tag;
			s->pen_u=1+(self->tag*2) ;
			s->pen_v=1+(self->tag*4) ;

			s->pen_y=255;
			s->pen_u=128 ;
			s->pen_v=128 ;

			//s->strokekind = 1;
			
		//app_log("glyph: stroke start");
			
			stroke_start(s,mx,my,args->mez);
		
		//app_log("glyph: stroke insert");
			
			page_strokeinsert(self->linkpage,s);		
	}
	else
	{
		
		// continue one
		
		//app_log("glyph: stroke continue, getting last");
		
			s = self->linkpage->strokelast;
			
		//app_log("glyph: stroke continue extending %i",(int)(s));
			
			stroke_extend(s,mx,my,args->mez);
			
		//app_log("glyph: stroke continue updating");
			
			page_strokeupdate(self->linkpage,s);
			
			
	}

	//app_log("glyph: sending home");

//	char buff[255];
//	snprintf(buff,255,"<point x=%i,y=%i,z=%i/>",args->mex,args->mey,args->mez);
//	senddata(buff);
	
}




















liqtile *mkglyph(char *letter)
{
	//liqtile *self = liqtile_createquick(NULL, 0, 0,     100, 100  );
	//liqtile *self = liqtile_createquick(NULL, 0, 0,     canvas.pixelwidth*0.125, canvas.pixelheight*0.25  );
	liqtile *self = liqtile_createquick(NULL, 0, 0,     canvas.pixelwidth/10, canvas.pixelheight/4  );
	
	//canvas.pixelwidth, canvas.pixelheight 
	
	
	self->style=NULL;//stylenone;//stylemenuitemdefault;
	self->tag=letter[0];
	self->handlerpaint = glyph_paint;
	self->handlermouse = glyph_mouse;
	//self->linkpage=fontpages[self->tag];			// restore previous
	
	liqtile_childappend(self,mklabel(letter));
	return self;
	
}






/*



		while(!feof(stdin))
		{
			int ch = getc(stdin);
			if(ch==EOF) break;
			char s[2];
			s[0]=ch;
			s[1]=0;
			app_log("STDIN: %i '%s'",(int)ch,s);
		}
		

*/




static int ui_event(struct liqtile *self,LIQEVENT *ev)
{
	// grab keys here :)
	//app_log("event!!!!! %i",ev->key.keycode);
	

		
		return 0;
}





static int page_paint(struct liqtile *self,liqtileeventpaint *args)
{	


	self->handlerpaint=NULL;
	liqtile_rendertocanvascr(self,args->ox,args->oy,NULL,args->cr);
	self->handlerpaint=page_paint;
	xfont_test();

	return 0;
}





int  liqidea_run()
{
	
	liqnettest_run();
	
	runfast=0;
	
	// lets go
	if(mk_style_open() != 0)
	{
		return app_warnandcontinue(-1,"Couldnt open default styles");
	}
	
	
	
	
	
		tileroot=liqtile_createquick("ui",0,0,canvas.pixelwidth,canvas.pixelheight);
		//tileroot->handlermouse=page_drawstroke_mouse;
		tileroot->handlerpaint=page_paint;
		//tileroot->style=stylemenuback;
		tileroot->handlerevent=ui_event;
		tileroot->style=styleblack;	
		
		
			tilepage=liqtile_createquick("page", canvas.pixelwidth*0, 0,     canvas.pixelwidth, canvas.pixelheight  );
			//tilepage->style=stylenone;
			//tilepage->handlermouse=page_drawstroke_mouse;
			//tilepage->handlerpaint=glyph_paint;
			liqtile_childappend(tileroot,tilepage);
			
			liqtile_childappend(tilepage,mkmenuitem("liqbase",0,(void*)btn_liqbase));
			
			char ch;
			for(ch='a';ch<='z';ch++)
			{
				char dat[2];
				dat[0]=ch;
				dat[1]=0;
				
				liqtile_childappend(tilepage,mkglyph(dat));
			}



/*			
			
			for(ch='A';ch<='Z';ch++)
			{
				char dat[2];
				dat[0]=ch;
				dat[1]=0;
				
				liqtile_childappend(tilepage,mkglyph(dat));
			}
*/


/*
			for(ch='0';ch<='9';ch++)
			{
				char dat[2];
				dat[0]=ch;
				dat[1]=0;
				
				liqtile_childappend(tilepage,mkglyph(dat));
			}
			
*/


/*			
				liqtile_childappend(tilepage,mkglyph("options"));
				liqtile_childappend(tilepage,mkglyph("friends"));
				liqtile_childappend(tilepage,mkglyph("news"));
				liqtile_childappend(tilepage,mkglyph("overview"));
				liqtile_childappend(tilepage,mkglyph("short"));
				liqtile_childappend(tilepage,mkglyph("medium"));
				liqtile_childappend(tilepage,mkglyph("full"));
*/

			liqtile_childappend(tilepage,    mkmenuitem("save"  ,1,(void*)btn_save)   );
			liqtile_childappend(tilepage,    mkmenuitem("cancel",2,(void*)btn_cancel)   );
			

			//liqtile_neatarrange_autofit(tilepage);
			liqtile_neatarrange(tilepage);
			
			
			liqtile* c=tilepage->linkchild;
			
			
			tilepage->y = c->h;
			liqtile_update_boundfrompos(tilepage);
			
		
		
		
		liqtile_easyrun2(tileroot,&runfast);
		
		
		liqtile_close(tileroot);

	
	
	mk_style_close();
}





