// this file is part of liqbase by Gary Birkett
		
#include <liqbase/liqbase.h>
#include <liqbase/liqcell.h>
#include <liqbase/liqcell_prop.h>
#include <liqbase/liqcell_easyrun.h>
#include <liqbase/liqcell_easyhandler.h>


#include "liqbookprogress.h"
	
		
//#####################################################################
//#####################################################################
//##################################################################### bookitem :: by gary birkett
//#####################################################################
//#####################################################################
		
		
/**	
 * bookitem widget filter, the system is asking you to filter to the specified .
 */	
static int bookitem_filter(liqcell *self,liqcellfiltereventargs *args, liqcell *context)
{
	// system is indicating the user has typed into the search box
	// you are expected to filter your content based upon this searchterm.
	// show or hide details and rearrange contents to apply this filter.
	char *searchterm = NULL;
	args->resultoutof=0;  // total number of searchable contents
	args->resultshown=0;  // count of options remaining after filtering.
	searchterm = args->searchterm;
	if(searchterm && *searchterm)
	{
		 // check the name property
		 args->resultoutof++;
		 if( stristr(self->name,searchterm) != NULL )
		 {
			  args->resultshown++;
		 }
		 // check the classname property
		 args->resultoutof++;
		 if( stristr(self->classname,searchterm) != NULL )
		 {
			  args->resultshown++;
		 }
		 // check any other properties or children and increment counters
		 // filter out list items recursively
	}
	return 0;
}
/**	
 * bookitem widget refresh, all params set, present yourself to the user.
 */	
static int bookitem_refresh(liqcell *self,liqcelleventargs *args, liqcell *context)
{
	return 0;
}
/**	
 * bookitem dialog_open - the user zoomed into the dialog
 */	
static int bookitem_dialog_open(liqcell *self,liqcelleventargs *args, liqcell *context)
{
	 return 0;
}
/**	
 * bookitem dialog_close - the dialog was closed
 */	
static int bookitem_dialog_close(liqcell *self,liqcelleventargs *args, liqcell *context)
{
	 return 0;
}
/**	
 * bookitem widget shown - occurs once per lifetime
 */	
static int bookitem_shown(liqcell *self,liqcelleventargs *args, liqcell *bookitem)
{
	liqcell *lblpath = liqcell_child_lookup(bookitem, "lblpath");
	liqcell *lblfraction = liqcell_child_lookup(bookitem, "lblfraction");
        //liqapp_log("book cap: '%s'",self->name);    
    liqcell_setcaption(lblpath, liqapp_filename_walkoverpath( self->name)   );
        //liqapp_log("book ca2: '%s'",self->name);    


		unsigned int sfl=0;
		unsigned int sfu=0;
		if(liqbookprogress_startreading_lookupposition(self->name,&sfl,&sfu) && (sfu>0))
		{
			//
			if(sfu>sfl-(self->h))sfu=sfl-self->h;
			liqapp_log("book layout, sfu=%d, sfl=%d",sfu,sfl);
			int frac = sfu * 100 / sfl;
			if(frac<0)frac=0;
			if(frac>100)frac=100;
			liqcell_setcaption_printf(lblfraction,"%d%%",frac);
			liqcell_propsets_printf(  lblfraction, "backcolor", "rgb(0,%d,0)", frac );
			liqcell_setvisible(lblfraction,1);
		}
		else
		{
			liqcell_setcaption(lblfraction,"0%");
			liqcell_propsets(  lblfraction, "backcolor", "rgb(0,0,0)" );
			liqcell_setvisible(lblfraction,0);
		}
        
    return 0;
}
/**	
 * bookitem mouse - occurs all the time as you stroke the screen
 */	
static int bookitem_mouse(liqcell *self, liqcellmouseeventargs *args,liqcell *context)
{
	return 0;
}
/**	
 * bookitem click - occurs when a short mouse stroke occured
 */	
static int bookitem_click(liqcell *self, liqcellclickeventargs *args,liqcell *context)
{
	return 0;
}
/**	
 * bookitem keypress - the user pressed a key
 */	
static int bookitem_keypress(liqcell *self, liqcellkeyeventargs *args,liqcell *context)
{
	return 0;
}
/**	
 * bookitem keyrelease - the user released a key
 */	
static int bookitem_keyrelease(liqcell *self, liqcellkeyeventargs *args,liqcell *context)
{
	return 0;
}
/**	
 * bookitem paint - being rendered.  use the vgraph held in args to do custom drawing at scale
 */	
//static int bookitem_paint(liqcell *self, liqcellpainteventargs *args,liqcell *context)
//{
//	// big heavy event, use sparingly
//	return 0;
//}
/**	
 * bookitem dynamic resizing
 */	
static int bookitem_resize(liqcell *self,liqcelleventargs *args, liqcell *context)
{
	float iw=((float)self->w);
	float ih=((float)self->h);
	
	liqcell *lblpath = liqcell_child_lookup(self, "lblpath");
	liqcell *lblfraction = liqcell_child_lookup(self, "lblfraction");
	liqcell_setrect( lblpath, iw*0.000,ih*0.050, iw*1.000,ih*0.900);
	liqcell_setrect( lblfraction, iw*0.819,ih*0.100, iw*0.176,ih*0.800);
	return 0;
}

/**	
 * bookitem_child_test_seek this function shows how to access members
 */	
	  
static void bookitem_child_test_seek(liqcell *bookitem)
{	  
	liqcell *lblpath = liqcell_child_lookup(bookitem, "lblpath");
	liqcell *lblfraction = liqcell_child_lookup(bookitem, "lblfraction");
	liqcell *resize1 = liqcell_child_lookup(bookitem, "resize1");
}	  
/**	
 * create a new bookitem widget
 */	
liqcell *bookitem_create()
{
	liqcell *self = liqcell_quickcreatewidget("bookitem", "form", 800, 58);
	if(!self) {liqapp_log("liqcell error not create 'bookitem'"); return NULL;  } 
	
	// Optimization:  The aim is to REDUCE the number of drawn layers and operations called.
	// Optimization:  use only what you NEED to get an effect
	// Optimization:  Minimal layers and complexity
	// Optimization:  defaults: background, prefer nothing, will be shown through if there is a wallpaper
	// Optimization:  defaults: text, white, very fast rendering
	//############################# lblpath:label
	liqcell *lblpath = liqcell_quickcreatevis("lblpath", "label", 4, 8, 648, 40);
	liqcell_setfont(	lblpath, liqfont_cache_getttf("/usr/share/fonts/nokia/nosnb.ttf", (24), 0) );
	liqcell_setcaption(lblpath, "Book Name" );
	liqcell_propsets(  lblpath, "textcolor", "rgb(255,255,255)" );
	liqcell_propsets(  lblpath, "backcolor", "rgb(0,30,0)" );
	liqcell_propseti(  lblpath, "textalign", 0 );
	liqcell_propseti(  lblpath, "textaligny", 2 );
	liqcell_child_append(  self, lblpath);
	//############################# lblfraction:label
	liqcell *lblfraction = liqcell_quickcreatevis("lblfraction", "label", 656, 4, 140, 48);
	liqcell_setfont(	lblfraction, liqfont_cache_getttf("/usr/share/fonts/nokia/nosnb.ttf", (24), 0) );
	liqcell_setcaption(lblfraction, "27%" );
	liqcell_propsets(  lblfraction, "textcolor", "rgb(255,255,255)" );
	//liqcell_propsets(  lblfraction, "backcolor", "rgb(0,0,64)" );
	liqcell_propsets(  lblfraction, "bordercolor", "rgb(255,255,255)" );
	liqcell_propseti(  lblfraction, "textalign", 2 );
	liqcell_propseti(  lblfraction, "textaligny", 2 );
	liqcell_child_append(  self, lblfraction);
	liqcell_setvisible(lblfraction,0);
	//liqcell_propsets(  self, "backcolor", "rgb(0,0,0)" );
	//liqcell_setimage(  self ,  liqimage_cache_getfile( "/usr/share/liqbase/liqbook/media/bookitem_back.png",0,0,0) );
	liqcell_handleradd_withcontext(self, "filter",		 (void*)bookitem_filter ,self);
	liqcell_handleradd_withcontext(self, "refresh",		(void*)bookitem_refresh ,self);
	liqcell_handleradd_withcontext(self, "shown",		  (void*)bookitem_shown ,self);
	liqcell_handleradd_withcontext(self, "resize",	  (void*)bookitem_resize ,self);
	//liqcell_handleradd_withcontext(self, "layout",	  (void*)bookitem_layout ,self);
	//liqcell_handleradd_withcontext(self, "keypress",	(void*)bookitem_keypress,self );
	//liqcell_handleradd_withcontext(self, "keyrelease", (void*)bookitem_keyrelease ,self);
	//liqcell_handleradd_withcontext(self, "mouse",		(void*)bookitem_mouse,self );
	//liqcell_handleradd_withcontext(self, "click",		(void*)bookitem_click ,self);
	//liqcell_handleradd_withcontext(self, "paint",		(void*)bookitem_paint ,self); // use only if required, heavyweight
	liqcell_handleradd_withcontext(self, "dialog_open",  (void*)bookitem_dialog_open ,self);
	liqcell_handleradd_withcontext(self, "dialog_close", (void*)bookitem_dialog_close ,self);
	return self;
}

