#!/usr/bin/env python2.5

import sys
import os
from os.path import isdir
from os.path import exists
from os import mkdir
from re import match

import pickle
from PyQt4.QtCore import *
from PyQt4.QtGui import *


CONFIG_PATH = '~/.maemo-webdav/'
CONFIG_FILE = CONFIG_PATH + 'shares.p'
NAME_REGEXP =  "[0-9]*"

LIGHTTPD_RESTART_COMMAND = 'sudo /etc/init.d/lighttpd restart'
LIGHTTPD_CONF_PATH = '/etc/lighttpd'
CONF_FILE = LIGHTTPD_CONF_PATH + '/conf-enabled/10-maemo-webdav.conf'

ALIAS_CONF_TEMPLATE = """alias.url += ( "/%s" => "%s" )
"""
DAV_CONF_TEMPLATE ="""$HTTP["url"] =~ "^/%s($|/)" {
    webdav.activate = "enable"
    webdav.is-readonly = "%s"
}
"""

class DavSettings(object):
    def __init__(self):
        self.shares = []
        
class Share(object):
    
    def __init__(self):
        self.name = 'New share'
        self.directory = ''
        self.writable = False

connect = QObject.connect

class MainWindow(object):
    def __init__(self):
        self.createWidgets()
        self.readSettings()
        self.itemToShare = {}
        self.updateSharesList()
        self.window.show()
    
    def readSettings(self):
        try:
            file = open(CONFIG_FILE, 'r')
            self.settings = pickle.load(file)
        except Exception, e:
            print "Can't read shares settings. Exception: %s" % e
            self.settings = DavSettings()
    
    def saveSettings(self):
        try:
            if not exists(CONFIG_PATH):
                mkdir(CONFIG_PATH)
            file = open(CONFIG_FILE, 'w')
            pickle.dump(self.settings, file)
        except Exception, e:
            print "Can't write shares settings. Exception: %s" % e 
    
    def updateSharesList(self):
        self.directoryList.clear()
        self.itemToShare.clear()
        for share in self.settings.shares:
            item = QListWidgetItem(share.name, self.directoryList)
            self.itemToShare[item] = share
        if self.settings.shares:
            self.directoryList.setCurrentRow(0)
    
    def updateSettingsView(self):
        if self.directoryList.currentItem():
            share = self.itemToShare[self.directoryList.currentItem()]
            self.shareNameEdit.setText(share.name)
            self.sourceDirectoryEdit.setText(share.directory)
            self.writableCheckbox.setChecked(share.writable)
    
    def saveSettingsFromView(self, share):
        shareName = str(self.shareNameEdit.text())
        directoryName = str(self.sourceDirectoryEdit.text())
        if not validateData(shareName, directoryName):
            QMessageBox.information(self.window, "Warning", "Data in fields is not valid")
        share.name = shareName
        share.directory = directoryName
        share.writable = self.writableCheckbox.isChecked()
    
    #signal handlers
    def applySettings(self):
        self.saveSettingsFromView(self.itemToShare[self.directoryList.currentItem()])
        for item, share in self.itemToShare.iteritems():
            item.setText(share.name)
        writeConf(self.settings)
        self.saveSettings()
        restartService()
    
    def addShare(self):
        self.settings.shares.append(Share())
        self.updateSharesList()
        newRowNum = len(self.settings.shares)-1
        self.directoryList.setCurrentRow(newRowNum)
    
    def removeShare(self):
        del self.settings.shares[self.directoryList.currentRow()]
        self.updateSharesList()
    
    def currentShareChanged(self, current, previous):
        if previous:
            self.saveSettingsFromView(self.itemToShare[previous])
        #refresh list labels
        self.updateSettingsView()
        for item, share in self.itemToShare.iteritems():
            item.setText(share.name)
    
    def selectDirectory(self):
        dialog = QFileDialog(self.window)
        dialog.setAcceptMode(0) #QFileDialog.AcceptMode.AcceptOpen
        dialog.setFileMode(2) #QFileDialog.FileMode.Directory
        #dialog.setOption(QFileDialog.ShowDirsOnly, True)
        #TODO set single selection!
        if (dialog.exec_()):
            self.sourceDirectoryEdit.setText(dialog.selectedFiles()[0])
    
    #view initialisation
    def createWidgets(self):
        #directory list edit view
        self.directoryList = QListWidget()
        self.directoryList.setSelectionMode(QAbstractItemView.SingleSelection)
        connect(self.directoryList, SIGNAL('currentItemChanged(QListWidgetItem*, QListWidgetItem*)'),
                self.currentShareChanged)
        self.addDirectoryButton = QPushButton()
        self.addDirectoryButton.setText('Add')
        connect(self.addDirectoryButton, SIGNAL('clicked()'),
                self.addShare)
        self.removeDirectoryButton = QPushButton()
        self.removeDirectoryButton.setText('Remove')
        connect(self.removeDirectoryButton, SIGNAL('clicked()'),
                self.removeShare)
        listEditLayout = QHBoxLayout()
        listEditLayout.addWidget(self.addDirectoryButton)
        listEditLayout.addWidget(self.removeDirectoryButton)
        listLayout = QVBoxLayout()
        listLayout.addWidget(self.directoryList)
        listLayout.addLayout(listEditLayout)
        
        #directory properties view
        self.shareNameEdit = QLineEdit()
        self.sourceDirectoryEdit = QLineEdit()
        self.sourceDirectoryButton = QPushButton()
        self.sourceDirectoryButton.setText('Select...')
        connect(self.sourceDirectoryButton, SIGNAL("clicked()"),
                self.selectDirectory)
        sourceDirectoryLayout = QHBoxLayout()
        sourceDirectoryLayout.addWidget(self.sourceDirectoryEdit)
        sourceDirectoryLayout.addWidget(self.sourceDirectoryButton)
        self.writableCheckbox = QCheckBox()
        propertiesLayout = QFormLayout()
        propertiesLayout.addRow('Name', self.shareNameEdit)
        propertiesLayout.addRow('Directory', sourceDirectoryLayout)
        propertiesLayout.addRow('Writable', self.writableCheckbox)
        
        #forming settings layout 
        settingsLayout = QHBoxLayout()
        settingsLayout.addLayout(listLayout)
        settingsLayout.addLayout(propertiesLayout)
        
        #main control buttons
        #self.startButton = QPushButton()
        #self.startButton.setText('Start')
        self.applyButton = QPushButton()
        self.applyButton.setText('Apply')
        connect(self.applyButton, SIGNAL('clicked()'),
                self.applySettings)
        controlButtonsLayout = QHBoxLayout()
        controlButtonsLayout.addStretch()
        #controlButtonsLayout.addWidget(self.startButton)
        controlButtonsLayout.addWidget(self.applyButton)
        
        #forming top-level layout
        mainVertical = QVBoxLayout()
        mainVertical.addLayout(settingsLayout)
        mainVertical.addLayout(controlButtonsLayout)
        
        self.window = QWidget()
        self.window.setWindowTitle('Maemo-WebDAV configuration')
        self.window.setLayout(mainVertical)

def validateData(name, directory):
    return isdir(directory) & (match(NAME_REGEXP, name) != None)

def writeConf(config):
    print 'Writing server configuration'
    try:
        confFile = open(CONF_FILE, 'w')
        for share in config.shares:
            confFile.write(ALIAS_CONF_TEMPLATE % (share.name, share.directory) )
            confFile.write(DAV_CONF_TEMPLATE %
                           (share.name, "disable" if share.writable else "enable") )
        confFile.close()
    except Exception, ex:
        print "Can't write server configuration. Exception : %s" % ex

def restartService():
    print 'Restarting service...'
    os.system(LIGHTTPD_RESTART_COMMAND)

if __name__=='__main__':
    app = QApplication(sys.argv)
    mainWindow = MainWindow()
    sys.exit(app.exec_())
