/*
Copyright (C) 2011  by Cuong Le <metacuong@gmail.com>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>
*/

import QtQuick 1.1

import "main.js" as Script
import "Themes.js" as Themes

Item{
    id:xntxhd

    anchors.verticalCenter: parent.verticalCenter
    width: parent.width; height: parent.height;
    x:(parent.width * 1.5)

    signal close

    Loader {
        id: theme_manager
        property alias theme: theme_manager.item
        source: Themes.default_theme()
    }

    Connections {
        target: xntxhd.parent

        onDialogClose: {
            xntxhd.state = "close";
            xntxhd.destroy(600);
        }
    }

    property string day_month_year_LN_CN:  ""
    property string nhi_thap_bat_tu:  ""
    property string truc:  ""
    property string luan_giai:  ""
    property string cac_sao_xau:  ""
    property string cac_sao_tot:  ""
    property string huong_xuat_hanh:  ""

    property string warnning:  "<span style='color:red;'>Thông tin trên đây được lấy nguồn từ <a href='http://www.xemngay.com'>www.xemngay.com</a> và chỉ mang tính chất <b>tham khảo</b></span>."

    Rectangle {
        id: rectangle1

        anchors.fill: parent; anchors.bottomMargin: 0;
        visible: true
        opacity:0.9


        Component {
            id: listDelegate

                Column {

                    Rectangle {
                                        width:rectangle1.width;
                                        y:30;
                                        x:0
                                        height:1
                                        border.color: "#b57e8f"
                    }

                    width:rectangle1.width

                    Rectangle{
                        width:rectangle1.width;
                        height:10;color:"transparent"
                    }

                    Text { x:5;y:50;text:getHD(name,idm) ;textFormat: Text.RichText;wrapMode: Text.WordWrap; font.pixelSize: 20
                        font.family: "Tahoma";width:parent.width-10;}

                    Rectangle{
                        width:rectangle1.width;
                        height:10;color:"transparent"
                    }
                }

        }


        ListModel {
                 id: listModel

                 ListElement {
                     idm:0;name: "";
                 }
                 ListElement {
                     idm:-1;name: "";
                 }
                 ListElement {
                     idm:1;name: "<b>Giờ Hoàng Đạo</b>";
                 }
                 ListElement {
                     idm:2;name: "<b>Tiết Khí</b>";
                 }
                ListElement {
                     idm:3;name: "<b>Nhị Thập Bát Tú</b>";
                 }
                ListElement {
                     idm:-2;name: "<b>Hướng Xuất Hành</b>";
                 }
                ListElement {
                     idm:6;name: "<b>Các Sao Tốt</b>";
                 }
               ListElement {
                     idm:7;name: "<b>Các Sao Xấu</b>";
                 }
               ListElement {
                   idm:8;name: "";
               }

               /* ListElement {
                     idm:5;name: "<b>Đánh Giá</b>";
                 }*/
         }



        ListView {
              id: listView
              anchors.fill: parent;anchors.topMargin: 45;anchors.leftMargin: 0;anchors.rightMargin: 0;anchors.bottomMargin: 55
              model: listModel
              delegate: listDelegate
              focus: true

              ScrollBar{}
        }

    }

    ToolBarSingle {
        id: toolBar; height: 42;
        y: parent.height-52
        width: parent.width;
        button1Label: "Quay Về"
        onButton1Clicked:xntxhd.close()
    }

    function getHD(name,idm){
        if (name.length){
            name="<span style='color:blue;'>"+name+"</span><br>";
        }

        reset();

        switch(idm){
        case 0 : return name+ xntxhd.day_month_year_LN_CN;break;
        case 1 : return name+Script.lunarGioHoangDao;break;
        case 2 : return name+Script.lunarTietKhi();break;
        case 3 : return name+xntxhd.nhi_thap_bat_tu; break;
        case 5 :  return name+xntxhd.luan_giai;break;
        case -1: return name+xntxhd.truc;break;
        case 6: return name+xntxhd.cac_sao_tot;break;
        case 7: return name+xntxhd.cac_sao_xau;break;
        case -2: return name+xntxhd.huong_xuat_hanh;break;
        case 8: return xntxhd.warnning;break;
        }
    }

    function reset(){
        xntxhd.day_month_year_LN_CN = Script.thu()+",ngày <b>"+Script.curDay+"</b> tháng <b>"+Script.curMonth+"</b> năm <b>"+Script.curYear+"</b><br>Ngày <b>"+Script.lunarDay+"</b> tháng <b>"+Script.lunarMonth+"</b> năm <b>"+Script.lunarYear+"</b> (<b>"+Script.lunarYearInt+"</b>)";
        xntxhd.nhi_thap_bat_tu = Script.sao(Script.curYear,Script.getLunarDate(Script.curDay,Script.curMonth,Script.curYear).jd - Script.getLunarDate(1,1,Script.curYear).jd);
        xntxhd.truc = Script.truc(Script.lunarMonth, Script.lunarDayCanChi, Script.lunarMonthCanChi);
        xntxhd.cac_sao_tot = Script.cacsaotot(Script.lunarMonth, Script.lunarDayCanChi);
        xntxhd.cac_sao_xau = Script.cacsaoxau(Script.lunarMonth, Script.lunarDayCanChi);
        xntxhd.luan_giai = Script.luangiai(Script.curDay);
        xntxhd.huong_xuat_hanh = Script.huong_xuat_hanh(Script.lunarDayCanChi);
    }

    Rectangle {
        width : xntxhd.width
        height: 45
        color:"white"
        opacity: 0.5
    }

    Text {
        id: title

        anchors { horizontalCenter: xntxhd.horizontalCenter; top: xntxhd.top; topMargin: 10 }
        font.pixelSize: 22
        color: "black"
        text: "Xem Ngày Tốt/Xấu"
        smooth: true
        font.bold: true
    }

    states: [
        State {
            name: "show"
            AnchorChanges { target: xntxhd; anchors.right: parent.right }
        },
        State {
            name: "close"
            AnchorChanges { target: xntxhd; anchors.right: parent.left }
        }
    ]

    transitions: Transition {
        AnchorAnimation { easing.type: Easing.OutQuart; duration: 300 }
    }

}
