.pragma library

Qt.include("amlich-hnd.js");
Qt.include("amlich-aa98.js");
Qt.include("Settings.js");
Qt.include("Themes.js");
Qt.include("CacNgayLeTrongNam.js");
Qt.include("xemngaytotxau.js");

var localdate = new Date();

var curDay=localdate.getDate();
var curMonth=localdate.getMonth()+1;
var curYear=localdate.getFullYear();

var initcurDay;
var initcurMonth;
var initcurYear;

var lunarDay = getLunarDate(curDay,curMonth,curYear).day;
var lunarMonth = getLunarDate(curDay,curMonth,curYear).month;
var lunarYear = getCanChi(getLunarDate(curDay,curMonth,curYear))[2];
var lunarYearInt = getLunarDate(curDay,curMonth,curYear).year;
var jd = getLunarDate(curDay,curMonth,curYear).jd;
var lunarGioHoangDao = getGioHoangDao(jd);

var lunarDayCanChi = getCanChi(getLunarDate(curDay,curMonth,curYear))[0];
var lunarMonthCanChi = getCanChi(getLunarDate(curDay,curMonth,curYear))[1];

var day_info = get(curDay,curMonth, curYear, lunarDay, lunarMonth);
var isholiday = is_holiday(curDay,curMonth, curYear, lunarDay, lunarMonth);

var datetimedlg;
var amdatetimedlg;
var fullmonth;

function init(){
    initcurDay = curDay;
    initcurMonth = curMonth;
    initcurYear = curYear;
}

function day_reset(){
    curDay = initcurDay;
}

function calDays(){
    if (curMonth == 4 || curMonth == 6 || curMonth == 9 || curMonth == 11)
        return 30;
    else
        if (curMonth == 2){
            var isLeapYear = (curYear % 4 === 0 && curYear % 100 !== 0) || (curYear % 400 ===0);
            if (isLeapYear)
                return 29;
            else
                return 28;
        }
    return 31;
}

function calDaysX(month, year){
    if (month == 4 || month == 6 || month == 9 || month == 11)
        return 30;
    else
        if (month == 2){
            var isLeapYear = (year % 4 === 0 && year % 100 !== 0) || (year % 400 ===0);
            if (isLeapYear)
                return 29;
            else
                return 28;
        }
    else
    return 31;
}

function thu(){
    return getTHU(jd);
}

function lunarTietKhi(){
    return TIETKHI[getSunLongitude(jd+1,7.0)];
}

function reset_to_default_day(txtTHU, txtInfo, txtDAYAmLich){
    localdate = new Date();

    curDay=localdate.getDate();
    curMonth=localdate.getMonth()+1;
    curYear=localdate.getFullYear();

    changeDay(curDay, txtTHU, txtInfo, txtDAYAmLich);
}

function changeDay(newday, txtTHU, txtInfo, txtDAYAmLich){
    curDay = newday;
    recalculate();

    txtTHU.text=__txtTHU_format();
    txtInfo.text=__txtInfo_format();
    txtDAYAmLich.text=__txtDAYAmLich_format();
}

function createDateTimeDialog(parent){
    datetimedlg = createObject("DateTimeDialog.qml", parent);
    amdatetimedlg = createObject("AmDateTimeDialog.qml", parent);
    fullmonth = createObject("FullMonth.qml", parent);
}

function __txtTHU_format(){
    return getTHU(jd);
}

function __txtInfo_format(){
    return day_info;
}

function __txtDAYAmLich_format(){
    return "Ngày <b>"+lunarDay+" ("+lunarDayCanChi+")</b><br>Tháng <b>"+lunarMonth+" ("+lunarMonthCanChi+")</b><br>Năm <b>"+lunarYearInt+" ("+lunarYear+")</b>";
}

function recalculate(){
    lunarDay = getLunarDate(curDay,curMonth,curYear).day;
    lunarMonth = getLunarDate(curDay,curMonth,curYear).month;
    lunarYear = getCanChi(getLunarDate(curDay,curMonth,curYear))[2];
    lunarYearInt = getLunarDate(curDay,curMonth,curYear).year;
    jd = getLunarDate(curDay,curMonth,curYear).jd;
    lunarGioHoangDao = getGioHoangDao(jd);

    lunarDayCanChi = getCanChi(getLunarDate(curDay,curMonth,curYear))[0];
    lunarMonthCanChi = getCanChi(getLunarDate(curDay,curMonth,curYear))[1];

    day_info = get(curDay,curMonth, lunarDay, lunarMonth);
    isholiday = is_holiday(curDay,curMonth, curYear, lunarDay, lunarMonth);
}

function createObject(sourceFile, parentObject) {
    var component = Qt.createComponent(sourceFile);
    var guiObject = component.createObject(parentObject);

    if (guiObject === null) {
        console.log("Error creating object");
    }
    else {
        return guiObject
    }
}
