/*
Copyright (C) 2011  by Cuong Le <metacuong@gmail.com>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>
*/

.pragma library

var optsGlobal = [];

function get_db(){
    return openDatabaseSync("LichVietDB", "1.0", "LichVietDB SQL", 5000);
}

function delete_old_db(){
    var db = get_db();
    db.transaction( function(tx) { try {
                           tx.executeSql('DROP TABLE Settings;');
                       } catch(error) {} }
                   );
}

function init_default(){
    return [
                {idm:1,name:"Chế Độ Xoay",selected:true},
                {idm:2,name:"Lịch Hệ Thống",selected:false},
                {idm:3,name:"Nhấn 2 Lần Liên Tiếp<br>Tới Ngày Dương",selected:true},
                {idm:4,name:"Nhấn Giữ<br>Xem Ngày Tốt/Xấu ...",selected:true}
            ];
}

function restore_nomodel(){
    var db = get_db();
    optsGlobal = [];

    function readEntry(json) {
        var parsed = JSON.parse(json);
        optsGlobal.push(parsed);
    }

    db.transaction( function(tx) {
                       try {
                           var rs = tx.executeSql('SELECT * FROM Settings');
                           for (var i = 0; i < rs.rows.length; i++) {
                               readEntry(rs.rows.item(i).json)
                           }
                       } catch (error) {
                           init_nomodel();
                       }
                   } );
}

function restore(objmodel){
    var db = get_db();
    objmodel.clear();

    optsGlobal = [];

    function readEntry(json) {
        var parsed = JSON.parse(json);
        optsGlobal.push(parsed);
        objmodel.append(parsed);
    }

    db.transaction( function(tx) {
                       try {
                           var rs = tx.executeSql('SELECT * FROM Settings');
                           for (var i = 0; i < rs.rows.length; i++) {
                               readEntry(rs.rows.item(i).json)
                           }
                       } catch (error) {
                           init(objmodel);
                       }
                   } );
}

function store(lopt){
    var db = get_db();
    db.transaction( function(tx) {
                       try{tx.executeSql('DROP TABLE Settings;');}catch(e){};
                              tx.executeSql('CREATE TABLE IF NOT EXISTS Settings(id INT, json TEXT)');
                   });
    for (var i=0;i<lopt.length;i++){
        db.transaction( function(tx) {
                           tx.executeSql('INSERT INTO Settings VALUES(?, ?)', [i+1, lopt[i]]);
                       });
    }
}

function save(obj){
    var lopts = [];
    optsGlobal = [];
    for (var i=0; i < obj.count; i++) {
        var newopt = "{";
        var firstpartopt = obj.get(i);

        for (var elem in firstpartopt) {
             if (!elem.match("^attributes")) {
                 newopt += "\""+elem+"\": \"" + firstpartopt[elem] + "\",";
             }
        }
        if (firstpartopt.attributes){
             newopt += "\"attributes\":[";
              for (var j=0; j < firstpartopt.attributes.count; j++) {
                    if (j > 0) newopt += ",";
                    var attr = firstpartopt.attributes.get(j);
                     newopt += JSON.stringify(attr);
              }
              newopt += "]";
        }else{
            newopt = newopt.slice(0, -1);
        }
         newopt += "}";
        lopts.push(newopt);
        optsGlobal.push( JSON.parse(newopt));
    }
    store(lopts);
}

function init_nomodel(){
    var listopts = init_default();
    optsGlobal = [];
    for(var i=0;i< listopts.length;i++){
        optsGlobal.push(listopts[i]);
    }
}

function init(obj){
    var listopts = init_default();
    optsGlobal = [];
    for(var i=0;i< listopts.length;i++){
        obj.append(listopts[i]);
        optsGlobal.push(listopts[i]);
    }
}

function pressandhold(){
    return get_opt(4);
}

function doubleclicked(){
    return get_opt(3);
}

function chedoxoay(){
    console.log(optsGlobal)
    return get_opt(1);
}

function get_opt(idm){
    for(var i=0;i<optsGlobal.length;i++){
        if (optsGlobal[i].idm == idm){
                if(optsGlobal[i].selected == "true" || optsGlobal[i].selected === true)
                    return 1;
        }
    }
   return 0;
}
