/*
 *  Copyright (C) 2013 Nicolai Hess
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef LEDPULSE_PULSEAUDIO_H_
#define LEDPULSE_PULSEAUDIO_H_
#include <pulse/pulseaudio.h>
#include <pulse/glib-mainloop.h>
#include <glib-object.h>

typedef struct {
  pa_context* pulse_context;
  pa_glib_mainloop* pulse_mainloop;
  pa_stream* pulse_stream;
} LedPulseAudio;

LedPulseAudio* ledpulse_pulseaudio_create();
void ledpulse_pulseaudio_init(LedPulseAudio* pa);
void ledpulse_pulseaudio_disconnect_stream(LedPulseAudio* pa);
void ledpulse_pulseaudio_enable_streaming(LedPulseAudio* pa, const gchar* source, void* data);
void ledpulse_pulseaudio_dispose(LedPulseAudio** pa);

#endif
