/*
 * lastgowh.h -- Main application window
 *
 * Copyright (C) 2010 Andrea Grandi
 * Authors: Andrea Grandi <a.grandi@gmail.com>
 *
 * This file is part of LastGo and is published under the GNU GPLv2
 * See the README file for more details.
 */

#ifndef LASTGOWH_H
#define LASTGOWH_H

#include <QMainWindow>
#include <QMap>
#include "lastfmtrack.h"
#include "apiclient.h"
#include <QMediaPlayer>
#include <QMediaPlaylist>
#include <QSettings>
#include "settingsdialog.h"
#include <QNetworkAccessManager>
#include <QNetworkReply>
#include "radiolist.h"
#include "aboutdialog.h"

namespace Ui
{
    class LastGoWH;
}

class LastGoWH : public QMainWindow
{
    Q_OBJECT

public:
    explicit LastGoWH(QWidget *parent = 0);
    void setUsername(QString user);
    void setPassword(QString pass);
    ~LastGoWH();

private slots:
    void requestReplied(QMap<QString, QString> reply);
    void radioGetPlaylistReplied(QList<LastfmTrack*> tracks);
    void playStopButtonClicked();
    void setupDesktopUI();
    void initializeMediaPlayer();
    void showSettingsDialog();
    void loadSettings();
    void saveSettings();
    void importApiKey();
    void connectMenuActions();
    void connectSlots();
    void authGetMobileSessionReplied(QMap<QString, QString> reply);
    void setPlayButtonToPlay();
    void setPlayButtonToStop();
    void playTrack(int i);
    void nextButtonClicked();
    void playerStateChanged(QMediaPlayer::State state);
    void trackPositionChanged(qint64 position);
    void imageRequestReplied(QNetworkReply *reply);
    void selectRadio();
    void radioTuneReplied(QMap<QString, QString> reply);
    void showAbout();
    void scrobblerHandshakeReplied(QMap<QString, QString> reply);
    void scrobblerPlayingReplied(QString reply);
    void scrobblerSubmissionReplied(QString reply);
    void scrobblerHandshake();
    void scrobblerPlaying();
    void scrobblerSubmission();

private:
    Ui::LastGoWH *ui;
    bool isPlaying;
    bool isTuning;
    bool isGettingPlayList;
    bool isSkipping;
    QList<LastfmTrack*> playlistTracks;
    ApiClient *ac;
    QMediaPlayer *player;
    QMediaPlaylist *playlist;
    int playListIndex;

    QSettings settings;
    QString username;
    QString password;
    QString sk;
    QString api_key;
    QString api_secret;

    QString scrobblingSession;
    QString scrobblingPlayingUrl;
    QString scrobblingSubmissionUrl;
    bool trackScrobbled;

    QNetworkAccessManager *manager;
    QString radioUrl;

};

#endif // LASTGOWH_H
